/*
 * Decompiled with CFR 0.152.
 */
package neverlang.utils;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import neverlang.utils.Triple;

public class ClassHelper {
    public static Class loadClass(String canonicalName) throws ClassNotFoundException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return classLoader.loadClass(canonicalName);
    }

    public static Object instantiateClass(String className) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Class<?> clazz = cl.loadClass(className);
            return clazz.newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Triple<String, String, Class> getNameAndClasspath(String path) {
        File file = new File(path);
        String classpath = "";
        ClassLoader classLoader = ClassHelper.class.getClassLoader();
        for (File folder = file.getParentFile(); folder != null; folder = folder.getParentFile()) {
            try {
                URL[] cp = new URL[]{folder.toURI().toURL()};
                classLoader = new URLClassLoader(cp, classLoader);
                String fname = file.getName();
                if (fname.endsWith(".class")) {
                    fname = fname.substring(0, fname.length() - 6);
                }
                if (!classpath.isEmpty()) {
                    fname = classpath + "." + fname;
                }
                Class<?> clazz = classLoader.loadClass(fname);
                return new Triple<String, String, Class>(fname, folder.getAbsolutePath(), clazz);
            }
            catch (ClassNotFoundException | NoClassDefFoundError | MalformedURLException e) {
                classpath = classpath.isEmpty() ? folder.getName() : classpath + "." + folder.getName();
                continue;
            }
        }
        return null;
    }
}

