/*
 * Decompiled with CFR 0.152.
 */
package neverlang.tools.ant;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import neverlang.Nlgc;
import neverlang.utils.StringUtils;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public class NlgcTask
extends Task {
    private List<String> fileList = new ArrayList<String>();
    private List<FileSet> fsets = new ArrayList<FileSet>();
    private String outputDir = ".";
    private Nlgc nlgc = new Nlgc();

    public void addFileset(FileSet fset) {
        this.fsets.add(fset);
    }

    public void setFilelist() {
        for (FileSet fset : this.fsets) {
            String[] includedFiles;
            DirectoryScanner ds = fset.getDirectoryScanner(this.getProject());
            for (String f : includedFiles = ds.getIncludedFiles()) {
                this.fileList.add(ds.getBasedir() + File.separator + f);
            }
        }
    }

    public void setDestdir(String outputDir) {
        this.outputDir = outputDir;
    }

    @Override
    public void execute() throws BuildException {
        this.setFilelist();
        this.nlgc.setFilePaths(this.fileList);
        this.nlgc.setOutputDir(this.getProject().resolveFile(this.outputDir).getAbsolutePath());
        try {
            this.log("Generating source files in " + this.outputDir + "...");
            this.nlgc.readFiles();
            this.nlgc.processFiles();
        }
        catch (Exception ex) {
            throw new BuildException(ex);
        }
        if (!this.nlgc.getErrors().isEmpty()) {
            throw new BuildException(StringUtils.join(this.nlgc.getErrors(), "\n"));
        }
    }
}

