/*
 * Decompiled with CFR 0.152.
 */
package neverlang.runtime.dexter;

import dexter.grammar.Grammar;
import dexter.grammar.NonTerminalSym;
import dexter.grammar.Symbol;
import dexter.grammar.TerminalSym;
import dexter.parser.DynamicParserException;
import dexter.parser.ITokenStream;
import dexter.parser.Item;
import dexter.parser.Kernel;
import dexter.parser.ParserState;
import dexter.parser.UnexpectedSymbolException;
import dexter.parser.ast.NodeStack;
import dexter.utils.NoSuchTransitionException;
import neverlang.runtime.dexter.ParsingStrategy;

public class DefaultParsingStrategy
implements ParsingStrategy {
    private boolean isShiftReduce(ParserState state) {
        return state.isTerminalState() && !state.goTo.isEmpty();
    }

    private Item getMaxScoredItem(Item max, Kernel kernel) {
        int maxScore = max.getScore();
        for (Item i : kernel) {
            int iScore = i.getScore();
            if (iScore < maxScore) continue;
            maxScore = iScore;
            max = i;
        }
        return max;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Item parse(ParserState state, ITokenStream tokens, NodeStack stack) {
        TerminalSym tokenSym;
        block11: {
            tokenSym = tokens.peek();
            if (!state.goTo.containsKey(tokenSym)) {
                if (state.goTo.containsKey(Grammar.EPSILON)) {
                    tokenSym = Grammar.EPSILON;
                    break block11;
                } else {
                    if (!state.isTerminalState()) throw new UnexpectedSymbolException(tokenSym, state.goTo.getTerminalSymbols(), state);
                    return state.reduce(tokenSym);
                }
            }
            if (this.isShiftReduce(state)) {
                Item candidate = state.kernel.getCandidates().get(0);
                try {
                    Item max = this.getMaxScoredItem(candidate, state.goTo.getTransition((Symbol)tokenSym).kernel);
                    if (max.productionEquals(candidate) && !candidate.isRightAssociative()) {
                        return state.reduce(tokenSym);
                    }
                }
                catch (NoSuchTransitionException ex) {
                    throw new Error(ex);
                }
            }
            tokens.getNext();
        }
        stack.push(tokenSym);
        Item firstReduceByRule = this.parse((ParserState)state.goTo.get(tokenSym), tokens, stack);
        NonTerminalSym reduceByNT = firstReduceByRule.nt;
        if (firstReduceByRule.pos == 0) {
            stack.reduce(firstReduceByRule.toProduction());
        }
        Item reduceByRule = firstReduceByRule;
        while (!reduceByRule.isKernel()) {
            if (!state.goTo.containsKey(reduceByNT)) {
                throw new DynamicParserException("Could not reduce by " + reduceByNT + " " + state.goTo + " in " + state.toString());
            }
            reduceByRule = this.parse((ParserState)state.goTo.get(reduceByNT), tokens, stack);
            reduceByNT = reduceByRule.nt;
            if (reduceByRule.pos != 0) continue;
            stack.reduce(reduceByRule.toProduction());
        }
        return reduceByRule.prev();
    }
}

