/*
 * Decompiled with CFR 0.152.
 */
package neverlang.runtime.dexter;

import dexter.grammar.NonTerminalSym;
import dexter.grammar.Production;
import dexter.grammar.Symbol;
import dexter.grammar.TerminalSym;
import dexter.lexter.QualifiedToken;
import it.unimi.dsi.fastutil.ints.Int2IntArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import java.io.File;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import neverlang.reflection.IAgent;
import neverlang.reflection.IPatternMatch;
import neverlang.reflection.NodeInfo;
import neverlang.reflection.UnregisterAgentException;
import neverlang.runtime.Context;
import neverlang.runtime.Role;
import neverlang.runtime.SemanticAction;
import neverlang.runtime.dexter.UndefinedAttributeException;
import neverlang.utils.Tuple;

public class ASTNode
extends dexter.parser.ast.ASTNode
implements Serializable {
    public int productionPos = -1;
    public Int2IntArrayMap childrenOffset = new Int2IntArrayMap();
    public final QualifiedToken token;
    private ASTNode parent;
    private Int2ObjectArrayMap<Tuple<SemanticAction, Context>> defaultActions = new Int2ObjectArrayMap();
    private final Int2ObjectArrayMap<List<SemanticAction>> actions = new Int2ObjectArrayMap();
    private final Int2ObjectArrayMap<List<SemanticAction>> removedActions = new Int2ObjectArrayMap();
    private boolean reconsiderActions = true;
    private List<Tuple<IAgent, IPatternMatch>> beforeAgents = null;
    private List<Tuple<IAgent, IPatternMatch>> afterAgents = null;
    private String rmiHandle;
    private static Map rmiHandles = new HashMap();
    private File file;
    public ASTNode[] ntchildren = new ASTNode[0];
    public ASTNode[] tchildren = new ASTNode[0];
    public ASTNode[] children = new ASTNode[0];

    public void setFile(File file) {
        this.file = file;
        for (ASTNode child : this.children) {
            child.setFile(file);
        }
    }

    public File getFile() {
        return this.file;
    }

    public ASTNode(Symbol s, ASTNode ... children) {
        super(s);
        this.token = s instanceof QualifiedToken ? (QualifiedToken)s : null;
        this.children = children;
    }

    public ASTNode(Symbol s) {
        super(s);
        this.token = s instanceof QualifiedToken ? (QualifiedToken)s : null;
        this.children = new ASTNode[0];
    }

    public ASTNode(Production p) {
        this(p.nt);
        this.rule = p;
        this.children = new ASTNode[this.rule.body.size()];
    }

    public void fillChildrenFields() {
        int count = 0;
        int ntc_i = 0;
        int tc_i = 0;
        if (this.rule == null) {
            return;
        }
        for (Symbol s : this.rule.body) {
            if (!(s instanceof NonTerminalSym)) continue;
            ++count;
        }
        ASTNode[] ntc = new ASTNode[count];
        ASTNode[] tc = new ASTNode[this.rule.body.size() - count];
        for (int i = 0; i < this.rule.body.size(); ++i) {
            Symbol s = (Symbol)this.rule.body.get(i);
            if (s instanceof NonTerminalSym) {
                ntc[ntc_i] = this.children[i];
                ++ntc_i;
            } else {
                tc[tc_i] = this.children[i];
                ++tc_i;
            }
            this.children[i].setParent(this);
        }
        this.ntchildren = ntc;
        this.tchildren = tc;
    }

    @Override
    public Production getProduction() {
        return this.rule;
    }

    @Override
    public int getId() {
        return this._id;
    }

    @Override
    public void setSymbol(Symbol symbol) {
        this.symbol = symbol;
    }

    @Override
    public <T extends Symbol> T getSymbol() {
        return (T)this.symbol;
    }

    public void addChild(ASTNode node) {
        int i = 0;
        while (this.children[i] != null) {
            ++i;
        }
        this.children[i] = node;
        node.setParent(this);
    }

    public ASTNode[] getChildren() {
        return this.children;
    }

    @Override
    public ASTNode getChild(int i) {
        return this.children[i];
    }

    public void setChild(int i, ASTNode n) {
        this.children[i] = n;
        n.setParent(this);
    }

    public ASTNode[] children() {
        return this.children;
    }

    @Override
    public ASTNode child(int i) {
        return this.children[i];
    }

    @Override
    public ASTNode ntchild(int i) {
        return this.ntchildren[i];
    }

    public ASTNode tchild(int i) {
        return this.tchildren[i];
    }

    @Override
    public <T> void setValue(String name, T value) {
        this.map.put(name, value);
    }

    @Override
    public <T> T getValue(String name) {
        if (this.map.containsKey(name)) {
            return (T)this.map.get(name);
        }
        if (this.ntchildren.length == 1) {
            try {
                return this.ntchildren[0].getValue(name);
            }
            catch (UndefinedAttributeException e) {
                throw new UndefinedAttributeException(name, this);
            }
        }
        throw new UndefinedAttributeException(name, this);
    }

    public HashMap<String, Object> getValues() {
        return this.map;
    }

    public void setValues(HashMap<String, Object> values) {
        this.map = values;
    }

    @Override
    public boolean equals(Object that) {
        return that instanceof ASTNode && that.hashCode() == this.hashCode();
    }

    @Override
    public int hashCode() {
        return this.symbol.hashCode();
    }

    @Override
    public String toString() {
        String s = this.symbol.toString() + "(";
        if (this.children == null || this.children.length == 0) {
            return s + ")";
        }
        for (int i = 0; i < this.children.length - 1; ++i) {
            s = s + this.children[i] + ", ";
        }
        return s + this.children[this.children.length - 1] + ")";
    }

    public String verbose() {
        StringBuilder sb = new StringBuilder();
        sb.append("********************\n");
        sb.append(this.toShortString(20));
        sb.append("\n\nAttributes:");
        for (String key : this.map.keySet()) {
            sb.append("\n - ").append(key).append(":").append(this.map.get(key));
        }
        sb.append("\n********************\n");
        return sb.toString();
    }

    public String toShortString(int maxLength) {
        String str = this.toString();
        int length = str.length();
        int max = length > maxLength ? maxLength : length;
        return str.substring(0, max);
    }

    private StringBuilder _toTerminalString(ASTNode node, StringBuilder sb) {
        if (node.getSymbol() instanceof TerminalSym && node.token != null) {
            sb.append(' ');
            return sb.append(node.token.text);
        }
        for (ASTNode ch : node.children) {
            if (ch == null) continue;
            this._toTerminalString(ch, sb);
        }
        return sb;
    }

    public String toTerminalString() {
        StringBuilder sb = this._toTerminalString(this, new StringBuilder());
        return sb.toString();
    }

    public ASTNode copy() {
        return this.copy(false);
    }

    public ASTNode copy(boolean copyAttributes) {
        ASTNode copy = this.rule == null ? new ASTNode(this.symbol) : new ASTNode(this.rule);
        for (int i = 0; i < this.children.length; ++i) {
            copy.children[i] = this.children[i].copy(copyAttributes);
        }
        copy.setParent(this.parent);
        copy.setFile(this.file);
        copy.childrenOffset = this.childrenOffset.clone();
        copy.productionPos = this.productionPos;
        copy.fillChildrenFields();
        if (copyAttributes) {
            for (String attrName : this.map.keySet()) {
                copy.setValue(attrName, this.map.get(attrName));
            }
        }
        if (this.map.containsKey("isExecutionStep")) {
            copy.setValue("isExecutionStep", this.map.get("isExecutionStep"));
        }
        copy.beforeAgents = this.beforeAgents;
        copy.afterAgents = this.afterAgents;
        return copy;
    }

    private HashMap<String, Object> copyAttributes() {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        for (String attrName : this.map.keySet()) {
            attrs.put(attrName, this.map.get(attrName));
        }
        return attrs;
    }

    protected void setNTChildren(ASTNode[] nonterminalChildren) {
        this.ntchildren = nonterminalChildren;
        for (ASTNode node : nonterminalChildren) {
            node.setParent(this);
        }
    }

    public void setParent(ASTNode node) {
        this.parent = node;
    }

    public int getChildPos(ASTNode child) {
        int pos = 0;
        for (ASTNode node : this.children) {
            if (node == child) {
                return pos;
            }
            ++pos;
        }
        return -1;
    }

    public int getNTChildPos(ASTNode child) {
        int pos = 0;
        for (ASTNode node : this.ntchildren) {
            if (node == child) {
                return pos;
            }
            ++pos;
        }
        return -1;
    }

    public void resetDefaultAction(Context ctx) {
        this.defaultActions.remove(ctx.roleId());
    }

    public void setDefaultAction(SemanticAction sa, Context ctx) {
        this.defaultActions.put(ctx.roleId(), new Tuple<SemanticAction, Context>(sa, ctx));
    }

    public void setDefaultAction(SemanticAction sa, Context ctx, Role role2) {
        Context newCtx = ctx.derive(this);
        int roleId = newCtx.getLang().getRoleId(role2);
        newCtx.changeRole(role2, roleId);
        this.defaultActions.put(roleId, new Tuple<SemanticAction, Context>(sa, newCtx));
    }

    public Tuple<SemanticAction, Context> getDefaultAction(int roleId) {
        if (this.defaultActions.containsKey(roleId)) {
            return this.defaultActions.get(roleId);
        }
        return null;
    }

    public Tuple<SemanticAction, Context> getDefaultAction(Context ctx) {
        return this.getDefaultAction(ctx.roleId());
    }

    public ASTNode getParent() {
        return this.parent;
    }

    public void setProduction(Production p) {
        this.rule = p;
    }

    public List<SemanticAction> filterRemovedActions(List<SemanticAction> actions, int roleId) {
        ArrayList<SemanticAction> result = new ArrayList<SemanticAction>();
        if (actions == null) {
            return result;
        }
        for (SemanticAction sa : actions) {
            if (this.isRemoved(sa, roleId)) continue;
            result.add(sa);
        }
        return result;
    }

    public List<SemanticAction> getActions(int roleId) {
        return this.actions.get(roleId);
    }

    public List<SemanticAction> getFilteredActions(int roleId) {
        return this.filterRemovedActions(this.actions.get(roleId), roleId);
    }

    public SemanticAction getActionByClassName(String className, int roleId) {
        List<SemanticAction> acts = this.actions.get(roleId);
        if (acts == null) {
            return null;
        }
        for (SemanticAction sa : acts) {
            if (!sa.getClass().getCanonicalName().contains(className)) continue;
            return sa;
        }
        return null;
    }

    public SemanticAction getActionByClassName(SemanticAction sa, int roleId) {
        return this.getActionByClassName(sa.getClass().getCanonicalName(), roleId);
    }

    public void addAction(SemanticAction sa, int roleId) {
        if (this.isRemoved(sa, roleId)) {
            this.restoreRemovedActions(sa, roleId);
            return;
        }
        SemanticAction ssa = this.getActionByClassName(sa, roleId);
        if (ssa == null) {
            List<SemanticAction> existing = this.actions.get(roleId);
            if (existing == null) {
                existing = new ArrayList<SemanticAction>();
                this.actions.put(roleId, existing);
            }
            existing.add(sa);
            this.invalidateActions();
        }
    }

    public boolean removeAction(SemanticAction sa, int roleId) {
        boolean res = false;
        SemanticAction ssa = this.getActionByClassName(sa.getClass().getCanonicalName(), roleId);
        if (ssa != null) {
            List<SemanticAction> existing = this.actions.get(roleId);
            res = existing.remove(ssa);
            this.invalidateActions();
        } else {
            System.out.println("Semantic action is null");
        }
        return res;
    }

    public boolean removeAction(Class actionClass, int roleId) {
        boolean res = false;
        List<SemanticAction> existing = this.actions.get(roleId);
        for (SemanticAction sa : existing) {
            if (!sa.getClass().getCanonicalName().equals(actionClass.getCanonicalName())) continue;
            existing.remove(sa);
            res = true;
            this.invalidateActions();
            break;
        }
        return res;
    }

    public boolean shouldReconsiderActions() {
        return this.reconsiderActions;
    }

    public void actionsConsidered() {
        this.reconsiderActions = false;
    }

    public void invalidateActions() {
        this.reconsiderActions = true;
    }

    public void addRemovedAction(SemanticAction sa, int roleId) {
        List<SemanticAction> roleActions = this.removedActions.get(roleId);
        if (roleActions == null) {
            roleActions = new ArrayList<SemanticAction>();
            this.removedActions.put(roleId, roleActions);
        }
        if (!roleActions.contains(sa)) {
            roleActions.add(sa);
        }
    }

    public boolean isRemoved(SemanticAction sa, int roleId) {
        List<SemanticAction> roleActions = this.removedActions.get(roleId);
        if (roleActions == null) {
            return false;
        }
        for (SemanticAction act : roleActions) {
            if (!act.isSameAs(sa)) continue;
            return true;
        }
        return false;
    }

    public void restoreRemovedActions(SemanticAction sa, int roleId) {
        List<SemanticAction> roleActions = this.removedActions.get(roleId);
        if (roleActions == null) {
            return;
        }
        int idx = 0;
        for (SemanticAction act : roleActions) {
            if (act.isSameAs(sa)) break;
            ++idx;
        }
        roleActions.remove(idx);
    }

    public List<SemanticAction> getRemovedActions(int roleId) {
        List<SemanticAction> get = this.removedActions.get(roleId);
        if (get == null) {
            return new ArrayList<SemanticAction>();
        }
        return get;
    }

    public ASTNode replaceWith(ASTNode newNode) {
        newNode.setParent(this.parent);
        newNode.setSymbol((Symbol)this.getSymbol());
        newNode.setProduction(this.getProduction());
        newNode.setParent(this.parent);
        newNode.productionPos = this.productionPos;
        newNode.ntchildren = this.ntchildren;
        newNode.tchildren = this.tchildren;
        newNode.children = this.children;
        if (this.parent != null) {
            int pos = this.parent.getChildPos(this);
            this.parent.setChild(pos, newNode);
            this.parent.fillChildrenFields();
            newNode.map = this.copyAttributes();
        }
        this.setParent(null);
        return newNode;
    }

    public String toStringAttributes() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (String name : this.map.keySet()) {
            sb.append(name).append("=").append(this.map.get(name)).append(", ");
        }
        sb.append("]");
        return sb.toString();
    }

    public HashMap<String, Object> getAttributes() {
        return this.map;
    }

    public void registerAgentBefore(IAgent agent, IPatternMatch pm) {
        if (this.beforeAgents == null) {
            this.beforeAgents = new ArrayList<Tuple<IAgent, IPatternMatch>>();
        }
        this.beforeAgents.add(new Tuple<IAgent, IPatternMatch>(agent, pm));
    }

    public void registerAgentAfter(IAgent agent, IPatternMatch pm) {
        if (this.afterAgents == null) {
            this.afterAgents = new ArrayList<Tuple<IAgent, IPatternMatch>>();
        }
        this.afterAgents.add(new Tuple<IAgent, IPatternMatch>(agent, pm));
    }

    public void beforeHook(Context ctx) throws RemoteException {
        List<Tuple<IAgent, IPatternMatch>> agents = this.beforeAgents;
        if (agents == null) {
            return;
        }
        Iterator it = agents.iterator();
        while (it.hasNext()) {
            Tuple agentInfo = (Tuple)it.next();
            IPatternMatch patternMatch = (IPatternMatch)agentInfo.y;
            IAgent agent = (IAgent)agentInfo.x;
            try {
                if (!patternMatch.dynamicConstraints()) continue;
                agent.before(patternMatch);
            }
            catch (UnregisterAgentException e) {
                it.remove();
            }
        }
    }

    public void afterHook(Context ctx) throws RemoteException {
        List<Tuple<IAgent, IPatternMatch>> agents = this.afterAgents;
        if (agents == null) {
            return;
        }
        Iterator it = agents.iterator();
        while (it.hasNext()) {
            Tuple agentInfo = (Tuple)it.next();
            IPatternMatch patternMatch = (IPatternMatch)agentInfo.y;
            IAgent agent = (IAgent)agentInfo.x;
            try {
                if (!patternMatch.dynamicConstraints()) continue;
                agent.after(patternMatch);
            }
            catch (UnregisterAgentException e) {
                it.remove();
            }
        }
    }

    public void setRmiHandle(String rmiHandle) {
        this.rmiHandle = rmiHandle;
    }

    public String getRmiHandle() {
        if (this.rmiHandle != null) {
            return this.rmiHandle;
        }
        this.rmiHandle = UUID.randomUUID().toString();
        rmiHandles.put(this.rmiHandle, this);
        return this.rmiHandle;
    }

    public static ASTNode getNodeByRmiHandle(String rmiHandle) {
        return (ASTNode)rmiHandles.get(rmiHandle);
    }

    public NodeInfo toNodeInfo() {
        return new NodeInfo(this);
    }
}

