/*
 * Decompiled with CFR 0.152.
 */
package neverlang.runtime;

import java.io.Serializable;
import java.net.URL;
import java.net.URLClassLoader;
import neverlang.Main;

public abstract class Unit
implements Serializable {
    protected String className = this.getClass().getCanonicalName();
    protected String pkgName = "" + this.getClass().getPackage();
    protected String name = this.getClass().getName();
    protected String language = "java";

    public String getCanonicalName() {
        return this.className;
    }

    public String getName() {
        return this.name;
    }

    public String getPackageName() {
        return this.pkgName;
    }

    public String getLanguage() {
        return this.language;
    }

    protected void dprint(Object o) {
        if (Main.VERBOSE) {
            System.out.println(o);
        }
    }

    private void printClassLoaderClassPath(ClassLoader cl) {
        URL[] urls = ((URLClassLoader)Thread.currentThread().getContextClassLoader()).getURLs();
        System.out.println("Classloader CLASSPATH:");
        for (URL u : urls) {
            System.out.println("- " + u);
        }
        System.out.println("\n\n");
    }

    protected Object loadClass(String className) {
        ClassLoader cl = this.getClass().getClassLoader();
        try {
            Class<?> clazz = cl.loadClass(className);
            return clazz.newInstance();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

