/*
 * Decompiled with CFR 0.152.
 */
package neverlang.runtime;

import dexter.grammar.Grammar;
import dexter.grammar.NonTerminalSym;
import dexter.grammar.SimpleNonTerminalSym;
import dexter.grammar.SimpleTerminalSym;
import dexter.grammar.Symbol;
import dexter.grammar.TerminalSym;
import dexter.lexter.KeywordTerminalSym;
import dexter.lexter.RegexTerminalSym;
import dexter.lexter.utils.Conversions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import neverlang.runtime.NullTaggedNonterminal;
import neverlang.runtime.Production;
import neverlang.runtime.TaggedNonterminal;
import neverlang.utils.Tuple;

public abstract class Syntax {
    protected String className = this.getClass().getCanonicalName();
    protected String name = this.getClass().getName();
    protected TaggedNonterminal[] provides = new TaggedNonterminal[0];
    protected TaggedNonterminal[] requires = new TaggedNonterminal[0];
    protected final Map<String, List<Symbol>> categoryToSymbols = new HashMap<String, List<Symbol>>();
    protected final Map<Symbol, String> symbolToCategory = new HashMap<Symbol, String>();
    protected final Map<String, String> categoryToDefaultStyle = new HashMap<String, String>();
    static HashMap<String, NonTerminalSym> nonterminals = new HashMap();
    int nonterminalCount = 0;
    HashMap<dexter.grammar.Production, Integer> productionPos = new HashMap();
    dexter.grammar.Production[] productions;

    public int getNonterminalCount() {
        return this.nonterminalCount;
    }

    public dexter.grammar.Production[] getProductions() {
        return this.productions;
    }

    protected void declareProductions(dexter.grammar.Production ... ps) {
        if (ps.length == 0) {
            throw new RuntimeException("Must declare at least one production");
        }
        this.productions = ps;
        this.nonterminalCount = 0;
        HashSet<TaggedNonterminal> tmpProvides = new HashSet<TaggedNonterminal>();
        HashSet<TaggedNonterminal> tmpRequires = new HashSet<TaggedNonterminal>();
        for (dexter.grammar.Production p : ps) {
            this.setPos(p, this.nonterminalCount);
            tmpProvides.add(new TaggedNonterminal(p.nt, new String[0]));
            ++this.nonterminalCount;
            for (Symbol s : p.body) {
                if (!(s instanceof NonTerminalSym)) continue;
                ++this.nonterminalCount;
                tmpRequires.add(new TaggedNonterminal((NonTerminalSym)s, new String[0]));
            }
        }
        if (this.provides.length == 0) {
            this.provides(tmpProvides.toArray(new TaggedNonterminal[tmpProvides.size()]));
        }
        if (this.requires.length == 0) {
            this.requires(tmpRequires.toArray(new TaggedNonterminal[tmpRequires.size()]));
        } else if (this.requires[0] instanceof NullTaggedNonterminal) {
            this.requires = new TaggedNonterminal[0];
        }
    }

    protected dexter.grammar.Production p(NonTerminalSym nt, Object ... symbols) {
        ++this.nonterminalCount;
        Symbol[] body = new Symbol[symbols.length];
        for (int i = 0; i < symbols.length; ++i) {
            SimpleTerminalSym ts;
            Object sym = symbols[i];
            if (sym instanceof String) {
                String keyword = (String)sym;
                TerminalSym ts2 = keyword.isEmpty() ? Grammar.EPSILON : new KeywordTerminalSym(keyword);
                body[i] = ts2;
                continue;
            }
            if (sym instanceof KeywordTerminalSym) {
                ts = (KeywordTerminalSym)sym;
                body[i] = ts;
                continue;
            }
            if (sym instanceof RegexTerminalSym) {
                ts = (RegexTerminalSym)sym;
                body[i] = ts;
                continue;
            }
            body[i] = (Symbol)sym;
            ++this.nonterminalCount;
        }
        return new Production(nt, body);
    }

    protected NonTerminalSym nt(String name) {
        if (nonterminals.containsKey(name)) {
            return nonterminals.get(name);
        }
        SimpleNonTerminalSym nt = new SimpleNonTerminalSym(name);
        nonterminals.put(name, nt);
        return nt;
    }

    protected RegexTerminalSym regex(String regex) {
        return Conversions.asRegex(regex);
    }

    protected RegexTerminalSym regex(String name, String regex) {
        return Conversions.asRegex(name, regex);
    }

    protected TerminalSym keyword(String keyword) {
        return new KeywordTerminalSym(keyword);
    }

    protected void requires(TaggedNonterminal ... nts) {
        this.requires = nts;
    }

    protected void provides(TaggedNonterminal ... nts) {
        this.provides = nts;
    }

    public TaggedNonterminal[] getRequires() {
        return this.requires;
    }

    public TaggedNonterminal[] getProvides() {
        return this.provides;
    }

    public TaggedNonterminal tag(NonTerminalSym nt, String tag, String ... moreTags) {
        String[] tags = new String[moreTags.length + 1];
        tags[0] = tag;
        for (int i = 0; i < moreTags.length; ++i) {
            tags[i + 1] = moreTags[i];
        }
        return new TaggedNonterminal(nt, tags);
    }

    public TaggedNonterminal tag(NonTerminalSym nt) {
        return new TaggedNonterminal(nt, new String[0]);
    }

    public String getCanonicalName() {
        return this.className;
    }

    public String getName() {
        return this.name;
    }

    public int getPos(dexter.grammar.Production p) {
        return this.productionPos.get(p);
    }

    public void setPos(dexter.grammar.Production p, int pos) {
        this.productionPos.put(p, pos);
    }

    public dexter.grammar.Production getByLabel(String label) {
        dexter.grammar.Production[] prods;
        for (dexter.grammar.Production p : prods = this.getProductions()) {
            String plabel = p.getLabel();
            if (plabel == null || !plabel.equals(label)) continue;
            return p;
        }
        return null;
    }

    public void addCategoryDefinition(String category, Symbol ... symbols) {
        this.addCategoryDefinition(category, Arrays.asList(symbols));
    }

    public void addCategoryDefinition(String category, List<Symbol> symbols) {
        if (this.categoryToSymbols.containsKey(category)) {
            this.categoryToSymbols.get(category).addAll(symbols);
        } else {
            this.categoryToSymbols.put(category, new ArrayList<Symbol>(symbols));
        }
        for (Symbol sym : symbols) {
            this.symbolToCategory.putIfAbsent(sym, category);
        }
    }

    public void addCategoryDefaultStyle(String category, String style2) {
        this.categoryToDefaultStyle.put(category, style2);
    }

    public void addDefaultStyles(List<Tuple<String, String>> categoryStylePairs) {
        for (Tuple<String, String> pair : categoryStylePairs) {
            if (!this.categoryToSymbols.containsKey(pair.x) || pair.y == null) continue;
            this.categoryToDefaultStyle.put((String)pair.x, (String)pair.y);
        }
    }

    public Map<String, List<Symbol>> getDeclaredCategories() {
        return this.categoryToSymbols;
    }

    public String getCategoryFor(Symbol sym) {
        return this.symbolToCategory.getOrDefault(sym, null);
    }

    public String getStyleFileFor(String category) {
        return this.categoryToDefaultStyle.getOrDefault(category, null);
    }
}

