/*
 * Decompiled with CFR 0.152.
 */
package neverlang.runtime;

import java.util.List;
import neverlang.runtime.NonterminalMapping;
import neverlang.runtime.RoleInterface;
import neverlang.runtime.Syntax;
import neverlang.runtime.dexter.ASTNode;

public class RoleDef
implements RoleInterface {
    private final String name;
    private final NonterminalMapping map;

    public RoleDef(String name, Syntax syn) {
        this.name = name;
        this.map = new NonterminalMapping(syn);
    }

    public RoleDef(String name, NonterminalMapping customMapping) {
        this.name = name;
        this.map = customMapping;
    }

    public RoleDef remap(int from, int to) {
        this.map.mapTo(from, to);
        return this;
    }

    public int image(int from) {
        int to = this.map.image(from);
        return to;
    }

    public int preimage(ASTNode n, int from) {
        int pre = this.map.preimage(n.getProduction(), from);
        return pre;
    }

    public void setMapping(List<Integer> fromList, List<Integer> toList) {
        if (fromList.size() != toList.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        for (int i = 0; i < fromList.size(); ++i) {
            this.remap(fromList.get(i), toList.get(i));
        }
    }

    public NonterminalMapping getMapping() {
        return this.map;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public String getName() {
        return this.name;
    }
}

