/*
 * Decompiled with CFR 0.152.
 */
package neverlang.runtime;

import dexter.grammar.IProductionBody;
import dexter.grammar.NonTerminalSym;
import dexter.grammar.ProductionBody;
import dexter.grammar.Symbol;
import dexter.lexter.KeywordTerminalSym;
import dexter.lexter.RegexTerminalSym;
import java.util.Collection;

public class Production
extends dexter.grammar.Production {
    private int id;

    public Production(NonTerminalSym nt, IProductionBody body) {
        super(nt, body);
    }

    public Production(NonTerminalSym nt, Symbol ... body) {
        super(nt, new ProductionBody(body));
    }

    public Production(NonTerminalSym nt, Collection<? extends Symbol> c) {
        super(nt, new ProductionBody(c.toArray(new Symbol[0])));
    }

    public String toSourceCode() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("p(nt(\"%s\")", this.nt));
        for (Symbol o : this.body) {
            sb.append(", ");
            if (o instanceof NonTerminalSym) {
                sb.append(String.format("nt(\"%s\")", o));
                continue;
            }
            if (o instanceof KeywordTerminalSym) {
                sb.append(String.format("\"%s\"", o));
                continue;
            }
            if (!(o instanceof RegexTerminalSym)) continue;
            RegexTerminalSym rt = (RegexTerminalSym)o;
            sb.append(String.format("regex(\"%s\", \"%s\")", this.convertPatternEscaping(rt.toString()), this.convertPatternEscaping(rt.getPattern().pattern())));
        }
        sb.append(")");
        String label = this.getLabel();
        if (label != null) {
            sb.append(String.format(".setLabel(\"%s\")", label));
        }
        sb.append(String.format(".setScore(%s)", this.score));
        return sb.toString();
    }

    public Production setIndex(int i) {
        this.id = i;
        return this;
    }

    public int getIndex() {
        return this.id;
    }

    private String convertPatternEscaping(String ptrn) {
        return this.escapeString(ptrn.replace("\\/", "/"));
    }

    private String escapeString(String input) {
        return input.replace("\\", "\\\\").replace("\"", "\\\"");
    }
}

