/*
 * Decompiled with CFR 0.152.
 */
package neverlang.runtime;

import dexter.grammar.Production;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import java.util.ArrayList;
import java.util.Collection;
import neverlang.runtime.Syntax;

public class NonterminalMapping {
    final int[] map;
    Syntax syn;
    Object2IntArrayMap<String> invertedMap = new Object2IntArrayMap();

    public NonterminalMapping(int size) {
        this.map = new int[size];
        for (int i = 0; i < size; ++i) {
            this.map[i] = i;
        }
    }

    public NonterminalMapping(Syntax syn) {
        this(syn.getNonterminalCount());
        this.syn = syn;
    }

    public NonterminalMapping mapTo(int from, int to) {
        this.map[from] = to;
        Production p = this.findProduction(from);
        this.invertedMap.put(this.invertedImageKey(p, to), from);
        return this;
    }

    private Production findProduction(int nonterminalId) {
        Production[] ps = this.syn.getProductions();
        int i = 0;
        int idx = 0;
        while (nonterminalId >= idx && ++i != ps.length) {
            idx = this.syn.getPos(ps[i]);
        }
        return ps[i - 1];
    }

    public int image(int from) {
        return this.map[from];
    }

    public int preimage(Production p, int to) {
        String k = this.invertedImageKey(p, to);
        if (this.invertedMap.containsKey(k)) {
            return this.invertedMap.get(k);
        }
        return to;
    }

    private String invertedImageKey(Production p, int to) {
        return to + ":" + p.toString();
    }

    public Collection<Integer> getMappedValues() {
        ArrayList<Integer> mappedValues = new ArrayList<Integer>();
        for (int i = 0; i < this.map.length; ++i) {
            if (i == this.map[i]) continue;
            mappedValues.add(i);
        }
        return mappedValues;
    }
}

