/*
 * Decompiled with CFR 0.152.
 */
package neverlang.runtime;

import dexter.grammar.Production;
import java.util.ArrayList;
import java.util.List;
import neverlang.runtime.ActionMap;
import neverlang.runtime.IdNonterminalMapping;
import neverlang.runtime.MissingSyntaxException;
import neverlang.runtime.ModuleInterface;
import neverlang.runtime.NOPSemanticAction;
import neverlang.runtime.RoleDef;
import neverlang.runtime.RoleMap;
import neverlang.runtime.SemanticAction;
import neverlang.runtime.Syntax;
import neverlang.runtime.Unit;
import neverlang.utils.Tuple;

public abstract class Module
extends Unit
implements ModuleInterface {
    protected RoleMap roleMap = new RoleMap();
    protected Production[] syntax = null;
    protected Syntax syntaxrole = null;
    private int counter = 0;
    private boolean hasSyntax = false;
    protected String syntaxFromModule;
    private String[] requiredEndemicSlices = new String[0];

    public String toString() {
        return String.format("%s(%s) hasSyntax: %s", this.className, this.roleMap.keySet(), this.hasSyntax);
    }

    @Override
    public void addAction(SemanticAction action, String role2, int pos) {
        this.roleMap.put(role2, pos, action);
    }

    @Override
    public void addAction(String role2, int pos, String action) {
        SemanticAction sa = (SemanticAction)this.loadClass(action);
        this.addAction(sa, role2, pos);
    }

    @Override
    public void removeAction(String role2, int pos, Class action) {
        try {
            this.roleMap.remove(role2, pos, (SemanticAction)action.newInstance());
        }
        catch (IllegalAccessException | InstantiationException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void removeAction(SemanticAction action, String role2) {
        this.roleMap.remove(action, role2);
    }

    @Override
    public int getProductionPos(Production p) {
        return this.getSyntaxRole().getPos(p);
    }

    @Override
    public Production[] getSyntax() {
        this.getSyntaxRole();
        if (this.syntaxrole != null) {
            this.syntax = this.syntaxrole.getProductions();
        }
        return this.syntax;
    }

    @Override
    public Syntax getSyntaxRole() {
        if (this.syntaxFromModule != null && this.syntaxrole == null) {
            this.declareSyntax();
            this.syntaxrole = this.loadSyntax(this.getSyntaxFrom());
        }
        if (this.syntaxrole != null) {
            return this.syntaxrole;
        }
        this.syntaxrole = this.loadSyntax();
        return this.syntaxrole;
    }

    @Override
    public String[] getRoles() {
        return this.roleMap.keySet().toArray(new String[0]);
    }

    public RoleMap getRoleMap() {
        return this.roleMap;
    }

    public void merge(Module other) {
        ActionMap otherActions;
        RoleMap otherRoleMap = other.getRoleMap();
        for (String role2 : this.roleMap.keySet()) {
            if (!otherRoleMap.containsKey(role2)) continue;
            otherActions = otherRoleMap.get(role2);
            this.roleMap.get(role2).putAll(otherActions);
        }
        for (String role2 : otherRoleMap.keySet()) {
            if (this.roleMap.containsKey(role2)) continue;
            otherActions = otherRoleMap.get(role2);
            this.roleMap.put(role2, otherActions);
        }
    }

    @Override
    public SemanticAction getAction(String role2, int pos) {
        if (this.hasAction(role2, pos)) {
            ActionMap m = this.roleMap.get(role2);
            SemanticAction sa = (SemanticAction)m.get(pos);
            if (sa == null) {
                sa = this.loadRole(role2, pos);
                if (sa == null) {
                    throw new RuntimeException("Could not load Action " + this.className + "::" + role2 + "(" + pos + ")");
                }
                m.put(pos, sa);
            }
            return sa;
        }
        return NOPSemanticAction.instance;
    }

    public SemanticAction getAction(String role2, String label) {
        List<Tuple<Integer, SemanticAction>> actions = this.getActions(role2);
        for (Tuple<Integer, SemanticAction> act : actions) {
            if (!((SemanticAction)act.y).getLabel().equals(label)) continue;
            return (SemanticAction)act.y;
        }
        return null;
    }

    @Override
    public List<Tuple<Integer, SemanticAction>> getActions(String role2) {
        ActionMap m = this.roleMap.get(role2);
        if (m == null) {
            throw new RuntimeException("Error getting actions for role: " + role2 + ". Please check the spelling.");
        }
        ArrayList<Tuple<Integer, SemanticAction>> result = new ArrayList<Tuple<Integer, SemanticAction>>();
        for (Integer pos : m.keySet()) {
            SemanticAction sa = (SemanticAction)m.get(pos);
            if (sa == null) {
                sa = this.loadRole(role2, pos);
                if (sa == null) {
                    throw new RuntimeException("Could not load Action " + this.className + "::" + role2 + "(" + pos + ")");
                }
                m.put(pos, sa);
            }
            result.add(new Tuple<Integer, SemanticAction>(pos, sa));
        }
        return result;
    }

    @Override
    public boolean hasRole(String role2) {
        return this.roleMap.containsKey(role2);
    }

    @Override
    public RoleDef getRoleDef(String role2) {
        int count = this.syntaxrole.getNonterminalCount();
        return new RoleDef(role2, new IdNonterminalMapping(this.syntaxrole.getNonterminalCount()));
    }

    @Override
    public boolean hasAction(String role2, int pos) {
        if (this.hasRole(role2)) {
            return this.roleMap.get(role2).containsKey(pos);
        }
        return false;
    }

    protected void declareSyntax() {
        this.hasSyntax = true;
    }

    protected void syntaxFrom(String moduleCanonicalName) {
        this.syntaxFromModule = moduleCanonicalName;
    }

    public String getSyntaxFrom() {
        return this.syntaxFromModule;
    }

    public boolean hasSyntax() {
        return this.hasSyntax;
    }

    protected void declareRole(String name, int ... actions) {
        if (actions.length == 0) {
            this.roleMap.put(name, ActionMap.EMPTY);
        }
        for (int act : actions) {
            this.roleMap.put(name, act, null);
        }
    }

    protected void requireEndemicSlices(String ... canonicalNames) {
        this.requiredEndemicSlices = canonicalNames;
    }

    @Override
    public String[] getRequiredEndemicSlices() {
        return this.requiredEndemicSlices;
    }

    private SemanticAction loadRole(String role2, int pos) {
        String className = this.className + "$role$" + role2 + "$" + pos;
        Object o = this.loadClass(className);
        Object sa = null;
        if (o instanceof SemanticAction) {
            this.dprint("loaded " + className);
            return (SemanticAction)o;
        }
        throw new RuntimeException(className + " must be an instance of " + SemanticAction.class.getCanonicalName());
    }

    private Syntax loadSyntax() {
        return this.loadSyntax(this.className);
    }

    protected Syntax loadSyntax(String synClassName) {
        try {
            String className = synClassName + "$role$syntax";
            Object o = this.loadClass(className);
            if (o instanceof Syntax) {
                this.dprint("loaded " + className);
                return (Syntax)o;
            }
            return null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new MissingSyntaxException(ex);
        }
    }

    @Override
    public void reset() {
        this.roleMap.clear();
    }
}

