/*
 * Decompiled with CFR 0.152.
 */
package neverlang.runtime;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import neverlang.runtime.ReinstantiationException;
import neverlang.runtime.Unit;

public abstract class EndemicSlice
extends Unit {
    Map<String, Object> instances = new HashMap<String, Object>();
    Map<String, Object> staticInstances = new HashMap<String, Object>();

    public EndemicSlice() {
        this.staticDeclarations();
    }

    public void init() {
    }

    public abstract void declarations();

    public abstract void staticDeclarations();

    public <T> void declare(String interfaceName, T initExpression) {
        this.instances.put(interfaceName, initExpression);
    }

    public <T> void declareStatic(String interfaceName, T initExpression) {
        if (this.staticInstances.containsKey(interfaceName)) {
            throw new ReinstantiationException("Cannot instance static declarations twice");
        }
        this.staticInstances.put(interfaceName, initExpression);
    }

    public <T> T getDeclaredInstance(String interfaceName) {
        return (T)this.instances.get(interfaceName);
    }

    public Map<String, Object> getDeclaredInstances() {
        return this.instances;
    }

    public Map<String, Object> getDeclaredStaticInstances() {
        return this.staticInstances;
    }

    public String[] getTags() {
        return new String[0];
    }

    public String[] getProvidedInstances() {
        this.declarations();
        HashSet<String> set = new HashSet<String>(this.instances.keySet());
        set.addAll(this.staticInstances.keySet());
        return set.toArray(new String[0]);
    }
}

