/*
 * Decompiled with CFR 0.152.
 */
package neverlang.reflection.dsl;

import java.util.Collection;
import java.util.HashMap;
import neverlang.reflection.dsl.IDeclaration;
import neverlang.reflection.dsl.SymbolTableException;

public class SymbolTable {
    private static SymbolTable instance = null;
    private final HashMap<String, IDeclaration> symbols = new HashMap();

    public static SymbolTable getInstance() {
        if (instance == null) {
            instance = new SymbolTable();
        }
        return instance;
    }

    public void putSymbol(String var, IDeclaration value) {
        this.symbols.put(var, value);
    }

    public IDeclaration getSymbol(String var) {
        IDeclaration res = this.symbols.get(var);
        if (res == null) {
            throw new SymbolTableException("Undefined identifier: " + var);
        }
        return res;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.symbols.keySet().stream().forEach(key -> sb.append((String)key).append(": ").append(this.symbols.get(key)).append("\n"));
        return sb.toString();
    }

    public Collection<String> getSymbols() {
        return this.symbols.keySet();
    }
}

