/*
 * Decompiled with CFR 0.152.
 */
package neverlang.reflection.dsl;

import java.text.MessageFormat;
import java.util.Collection;
import neverlang.reflection.AttributeValue;
import neverlang.reflection.ChildPattern;
import neverlang.reflection.ITreePattern;
import neverlang.reflection.NonterminalPattern;
import neverlang.reflection.PrecedesPattern;
import neverlang.reflection.ProductionPattern;
import neverlang.reflection.TreePattern;
import neverlang.utils.Tuple;

public class PatternTranslator {
    private static long idCounter = 0L;
    private static final String NONTERMINAL_TEMPLATE = "new NonterminalPattern(\"{4}\",\"{0}\", \"{1}\", {2}, new HashSet(Arrays.asList({3})))";
    private static final String PRODUCTION_TEMPLATE = "new ProductionPattern(\"{3}\", \"{0}\", \"{1}\", new HashSet(Arrays.asList({2})))";
    private static final String PRECEDES_TEMPLATE = "new PrecedesPattern({0}, {1})";
    private static final String CHILD_TEMPLATE = "new ChildPattern({0}, {1})";

    private static String _translate(ITreePattern pattern) {
        if (pattern == null) {
            return null;
        }
        TreePattern tp = (TreePattern)pattern;
        StringBuilder attrSb = new StringBuilder();
        boolean first = true;
        Collection<AttributeValue> attributes = tp.getAttributes();
        if (attributes != null) {
            for (AttributeValue attrValue : tp.getAttributes()) {
                if (!first) {
                    attrSb.append(", ");
                } else {
                    first = false;
                }
                String value = attrValue.getValue() instanceof String ? String.format("\"%s\"", attrValue.getValue()) : attrValue.getValue().toString();
                attrSb.append(String.format("new AttributeValue(\"%s\", %s)", attrValue.getName(), value));
            }
        }
        if (pattern instanceof NonterminalPattern) {
            NonterminalPattern np = (NonterminalPattern)pattern;
            return MessageFormat.format(NONTERMINAL_TEMPLATE, np.getModule(), np.getLabel(), np.getPosition(), attrSb.toString(), np.getId());
        }
        if (pattern instanceof ProductionPattern) {
            ProductionPattern pp = (ProductionPattern)pattern;
            return MessageFormat.format(PRODUCTION_TEMPLATE, pp.getModule(), pp.getLabel(), attrSb.toString(), pp.getId());
        }
        if (pattern instanceof PrecedesPattern) {
            PrecedesPattern bp = (PrecedesPattern)pattern;
            return MessageFormat.format(PRECEDES_TEMPLATE, PatternTranslator._translate(bp.getLeft()), PatternTranslator._translate(bp.getRight()), attrSb.toString());
        }
        if (pattern instanceof ChildPattern) {
            ChildPattern cp = (ChildPattern)pattern;
            return MessageFormat.format(CHILD_TEMPLATE, PatternTranslator._translate(cp.getLeft()), PatternTranslator._translate(cp.getRight()), attrSb.toString());
        }
        throw new UnsupportedOperationException("Unrecognized pattern type.");
    }

    public static Tuple<String, String> translate(ITreePattern pattern) {
        String id = PatternTranslator.createID();
        String result = MessageFormat.format("        ITreePattern {0} = {1};\n", id, PatternTranslator._translate(pattern));
        return new Tuple<String, String>(id, result);
    }

    private static synchronized String createID() {
        return "pattern" + String.valueOf(idCounter++);
    }
}

