/*
 * Decompiled with CFR 0.152.
 */
package neverlang.reflection;

import dexter.grammar.Production;
import java.util.ArrayList;
import java.util.Set;
import neverlang.reflection.AttributeValue;
import neverlang.reflection.ProductionPatternMatch;
import neverlang.reflection.TreePattern;
import neverlang.runtime.Context;
import neverlang.runtime.Language;
import neverlang.runtime.dexter.ASTNode;

public class ProductionPattern
extends TreePattern {
    private Production production;
    private final String module;
    private final String label;

    public ProductionPattern(String id, String module, String label, Set<AttributeValue> attrs) {
        this.id = id;
        this.module = module;
        this.label = label;
        this.attributes = attrs;
    }

    public String getModule() {
        return this.module;
    }

    public String getLabel() {
        return this.label;
    }

    @Override
    public void init(Context ctx) {
        Production[] moduleGrammar;
        Language language = ctx.getLang();
        this.production = null;
        for (Production p : moduleGrammar = language.getModuleGrammar(this.module)) {
            if (!p.getLabel().equals(this.label)) continue;
            this.production = p;
            break;
        }
    }

    @Override
    public boolean matches(Context ctx) {
        if (this.production == null) {
            return false;
        }
        ASTNode node = ctx.node();
        Production currentProd = node.getProduction();
        boolean match = currentProd.equals(this.production);
        if (match) {
            ArrayList<ASTNode> nodes = new ArrayList<ASTNode>();
            nodes.add(node);
            for (ASTNode ch : node.ntchildren) {
                nodes.add(ch);
            }
            this.addMatch(new ProductionPatternMatch(this, nodes, this.id));
        }
        return match;
    }

    public String toString() {
        return String.format("ProductionPattern(id=%s, label=%s, module=%s, production=%s)", this.id, this.label, this.module, this.production != null ? this.production.toString() : "N/A");
    }

    @Override
    public int priority() {
        return this.production.getScore();
    }

    public Production getProduction() {
        if (this.production == null) {
            throw new RuntimeException("Production is null. Did you call getProduction() before calling init()?!");
        }
        return this.production;
    }
}

