/*
 * Decompiled with CFR 0.152.
 */
package neverlang.reflection;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;

public class PatternFilter
implements Serializable {
    private final Collection<String> idList;

    public PatternFilter(Collection<String> idList) {
        this.idList = idList;
    }

    public PatternFilter() {
        this.idList = new ArrayList<String>();
    }

    public Collection<String> getIdList() {
        return this.idList;
    }

    public boolean shouldRegister(String id) {
        return this.idList.contains(id);
    }

    public String translate(String patternId) {
        if (this.idList.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String id : this.idList) {
            if (!first) {
                sb.append(",");
            }
            first = false;
            sb.append(String.format("\"%s\"", id));
        }
        return String.format("        %s.setPatternFilter(new PatternFilter(Arrays.asList(%s)));\n", patternId, sb.toString());
    }

    public String toString() {
        return this.idList == null ? "" : this.idList.toString();
    }
}

