/*
 * Decompiled with CFR 0.152.
 */
package neverlang.reflection;

import dexter.grammar.NonTerminalSym;
import dexter.grammar.Production;
import java.rmi.RemoteException;
import java.util.Set;
import neverlang.reflection.AttributeValue;
import neverlang.reflection.NonterminalPatternMatch;
import neverlang.reflection.TreePattern;
import neverlang.runtime.Context;
import neverlang.runtime.Language;
import neverlang.runtime.dexter.ASTNode;

public class NonterminalPattern
extends TreePattern {
    private NonTerminalSym nonterminal;
    private Production production;
    private final String module;
    private final String label;
    private final int position;

    public NonterminalPattern(String id, String module, String label, int position, Set<AttributeValue> attrs) {
        this.module = module;
        this.label = label;
        this.position = position;
        this.attributes = attrs;
        this.id = id;
    }

    @Override
    public boolean matches(Context ctx) {
        boolean should = true;
        ASTNode node = ctx.node();
        ASTNode parent = node.getParent();
        if (this.getPosition() == 0) {
            should = node.getProduction().equals(this.production);
            if (should) {
                this.addMatch(new NonterminalPatternMatch(this, node, this.id));
            }
        } else if (parent != null) {
            int ppos = parent.getNTChildPos(node) + 1;
            should = should && parent.getProduction().equals(this.production);
            boolean bl = should = should && ppos == this.getPosition();
            if (should) {
                this.addMatch(new NonterminalPatternMatch(this, node, this.id));
            }
        } else {
            should = false;
        }
        return should;
    }

    @Override
    public void init(Context ctx) throws RemoteException {
        Production[] moduleGrammar;
        Language language = ctx.getLang();
        this.production = null;
        for (Production p : moduleGrammar = language.getModuleGrammar(this.getModule())) {
            if (!p.getLabel().equals(this.getLabel())) continue;
            this.production = p;
            break;
        }
        if (this.production == null) {
            throw new RuntimeException("Production labeled " + this.getLabel() + " does not exist!");
        }
        try {
            this.nonterminal = this.production.getNonterminals().get(this.getPosition());
        }
        catch (IndexOutOfBoundsException e) {
            throw new RemoteException("No nonterminal at position " + this.getPosition() + " in production: " + this.production.toString());
        }
    }

    public String getModule() {
        return this.module;
    }

    public String getLabel() {
        return this.label;
    }

    public int getPosition() {
        return this.position;
    }

    public String toString() {
        return String.format("NonterminalPattern(id=%s, nt=%s, label=%s, module=%s, pos=%d)", this.id == null ? "N/A" : this.id, this.nonterminal, this.label, this.module, this.position);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof NonterminalPattern)) {
            return false;
        }
        NonterminalPattern other = (NonterminalPattern)obj;
        return this.module.equals(other.getModule()) && this.label.equals(other.getLabel()) && this.position == other.getPosition();
    }
}

