/*
 * Decompiled with CFR 0.152.
 */
package neverlang.reflection;

import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import neverlang.reflection.IPatternMatch;
import neverlang.reflection.ITreePattern;
import neverlang.reflection.NodeInfo;
import neverlang.reflection.PatternMatch;
import neverlang.runtime.dexter.ASTNode;

public class BinaryPatternMatch
extends PatternMatch {
    private final IPatternMatch left;
    private final IPatternMatch right;

    public BinaryPatternMatch(ITreePattern pattern, IPatternMatch left, IPatternMatch right) {
        super(pattern);
        this.left = left;
        this.right = right;
    }

    @Override
    public Collection<ASTNode> getNodes() {
        return Stream.concat(this.left.getNodes().stream(), this.right.getNodes().stream()).collect(Collectors.toList());
    }

    public String toString() {
        return String.format("Bin(L=%s, R=%s)@%d", this.left.toString(), this.right.toString(), System.identityHashCode(this));
    }

    @Override
    public boolean dynamicConstraints() {
        return this.left.dynamicConstraints() && this.right.dynamicConstraints();
    }

    @Override
    public NodeInfo[] getNodesInfo(String id) {
        throw new UnsupportedOperationException("Cannot call getNodesInfo on a binary pattern match. You've hit a bug in your code. :(\n\nIf the code was automatically generated, then please check your code generation tool.");
    }

    @Override
    public NodeInfo getNodeInfo(String id) {
        NodeInfo nodeInfo = this.left.getNodeInfo(id);
        if (nodeInfo == null) {
            nodeInfo = this.right.getNodeInfo(id);
        }
        return nodeInfo;
    }
}

