/*
 * Decompiled with CFR 0.152.
 */
package neverlang.reflection;

import java.rmi.RemoteException;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import neverlang.reflection.ITreePattern;
import neverlang.reflection.TreePattern;
import neverlang.runtime.Context;

public abstract class BinaryPattern
extends TreePattern {
    protected ITreePattern left;
    protected ITreePattern right;

    public BinaryPattern(ITreePattern left, ITreePattern right) {
        this.left = left;
        this.right = right;
    }

    public ITreePattern getLeft() {
        return this.left;
    }

    public ITreePattern getRight() {
        return this.right;
    }

    @Override
    public void init(Context ctx) throws RemoteException {
        this.left.init(ctx);
        this.right.init(ctx);
        if (this.right.priority() < this.left.priority()) {
            ITreePattern temp = this.left;
            this.left = this.right;
            this.right = temp;
        }
    }

    @Override
    public Set<String> getIds() {
        return Stream.concat(this.left.getIds().stream(), this.right.getIds().stream()).collect(Collectors.toSet());
    }

    @Override
    public void resetMatches() {
        super.resetMatches();
        this.left.resetMatches();
        this.right.resetMatches();
    }
}

