/*
 * Decompiled with CFR 0.152.
 */
package neverlang.compiler.syn;

import dexter.grammar.NonTerminalSym;
import dexter.grammar.Symbol;
import dexter.lexter.KeywordTerminalSym;
import dexter.lexter.RegexTerminalSym;
import java.util.Arrays;
import java.util.List;
import neverlang.runtime.Module;
import neverlang.runtime.Production;
import neverlang.runtime.Syntax;
import neverlang.runtime.TaggedNonterminal;
import neverlang.utils.StringUtils;

public class SyntaxRoleSource
extends Syntax {
    String src;
    String mname;
    Module m;
    final String tplName = "%s$role$syntax";
    final String imports = "import neverlang.runtime.Syntax;\n\n";
    final String tplFile = "public class %s extends Syntax {\n public %s() {\n%s%s   declareProductions(\n%s\n   );\n   %s\n }\n}";

    public String toString() {
        return this.getPackageString() + "import neverlang.runtime.Syntax;\n\n" + String.format("public class %s extends Syntax {\n public %s() {\n%s%s   declareProductions(\n%s\n   );\n   %s\n }\n}", this.name, this.name, this.providesToString(), this.requiresToString(), this.productionsToString(), this.categoriesToString());
    }

    private String productionsToString() {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (dexter.grammar.Production o : this.getProductions()) {
            if (i > 0) {
                sb.append(",\n");
            }
            ++i;
            sb.append("    ");
            sb.append(o.toString());
        }
        return sb.toString();
    }

    private void taggedNonterminal(StringBuilder sb, TaggedNonterminal t) {
        sb.append("    ");
        sb.append("tag(nt(\"");
        sb.append(t.getNonterminal());
        String[] tags = t.getTags();
        if (tags.length != 0) {
            sb.append("\"), \"");
            sb.append(StringUtils.join(Arrays.asList(t.getTags()), "\", \""));
            sb.append("\")");
        } else {
            sb.append("\"))");
        }
    }

    private String taggedNonterminalList(TaggedNonterminal[] taggedNts) {
        int i;
        StringBuilder sb = new StringBuilder();
        for (i = 0; i < taggedNts.length - 1; ++i) {
            this.taggedNonterminal(sb, taggedNts[i]);
            sb.append(",\n");
        }
        this.taggedNonterminal(sb, taggedNts[i]);
        sb.append("\n");
        return sb.toString();
    }

    private String providesToString() {
        if (this.provides.length == 0) {
            return "";
        }
        return "  provides(\n" + this.taggedNonterminalList(this.provides) + "  );\n";
    }

    private String requiresToString() {
        if (this.requires.length == 0) {
            return "";
        }
        return "  requires(\n" + this.taggedNonterminalList(this.requires) + "  );\n";
    }

    public void setModule(Module m) {
        this.m = m;
        this.setModuleName(m.getName());
    }

    public void setModuleName(String mname) {
        this.mname = mname;
        this.className = this.name = String.format("%s$role$syntax", mname);
    }

    public String getModuleName() {
        return this.mname;
    }

    private int countNonterminals(Production p) {
        int count = 1;
        for (int i = 0; i < p.body.size(); ++i) {
            if (!(p.body.get(i) instanceof NonTerminalSym)) continue;
            ++count;
        }
        return count;
    }

    public void declareProductions(Production ... ps) {
        super.declareProductions(ps);
        int count = 0;
        for (Production p : ps) {
            p.setIndex(count);
            count += this.countNonterminals(p);
        }
    }

    @Override
    public void requires(TaggedNonterminal ... nts) {
        super.requires(nts);
    }

    @Override
    public void provides(TaggedNonterminal ... nts) {
        super.provides(nts);
    }

    public String getPackageString() {
        return this.m.getPackageName().isEmpty() ? "" : "package " + this.m.getPackageName() + ";\n";
    }

    public String categoriesToString() {
        StringBuilder sb = new StringBuilder();
        for (String cat : this.categoryToSymbols.keySet()) {
            sb.append("addCategoryDefinition(\"").append(cat).append("\"");
            for (Symbol sym : (List)this.categoryToSymbols.get(cat)) {
                sb.append(",").append(this.symToSourceCode(sym));
            }
            sb.append(");").append("\n");
            if (!this.categoryToDefaultStyle.containsKey(cat)) continue;
            sb.append("addCategoryDefaultStyle(\"").append(cat).append("\",\"").append((String)this.categoryToDefaultStyle.get(cat)).append("\");").append("\n");
        }
        return sb.toString();
    }

    private String symToSourceCode(Symbol sym) {
        if (sym instanceof NonTerminalSym) {
            return String.format("nt(\"%s\")", sym);
        }
        if (sym instanceof KeywordTerminalSym) {
            return String.format("keyword(\"%s\")", sym);
        }
        if (sym instanceof RegexTerminalSym) {
            RegexTerminalSym rt = (RegexTerminalSym)sym;
            return String.format("regex(\"%s\", \"%s\")", this.convertPatternEscaping(rt.toString()), this.convertPatternEscaping(rt.getPattern().pattern()));
        }
        return "";
    }

    private String convertPatternEscaping(String ptrn) {
        return this.escapeString(ptrn.replace("\\/", "/"));
    }

    private String escapeString(String input) {
        return input.replace("\\", "\\\\").replace("\"", "\\\"");
    }
}

