/*
 * Decompiled with CFR 0.152.
 */
package neverlang.compiler.plugins.translator;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import neverlang.compiler.plugins.translator.TranslatorPlugin;

public class JavaTranslatorPlugin
extends TranslatorPlugin {
    private static final Pattern multiLineString = Pattern.compile("'''(.*?)'''", 32);
    private static final Pattern stringInterpolation = Pattern.compile("\\$\\{(.*)\\}");
    private static final String quote = "\"";

    public JavaTranslatorPlugin() {
        this.language = "java";
        this.fileExtension = "java";
        this.defaultLanguage = true;
        this.packageString = "package {0};";
        this.importString = "import {0};";
        this.fileTemplate = "public class {0} implements {1}, java.io.Serializable '{'\n\n  private int priority = {4};\n\n  private boolean softGuard = {5};\n\n  @Override\n  public boolean isSoftGuarded() '{' return softGuard; '}'\n\n  @Override\n  public int getPriority() '{' return priority; '}'\n\n  @Override\n  public void setPriority(int p) '{' priority = p; '}'\n\n  @Override\n  public String getLabel() '{' return \"{6}\"; '}'\n\n  @Override\n  public int getPosition() '{' return {7}; '}'\n\n  @Override\n  public boolean predicate(Context $ctx) '{'\n    ASTNode $n = $ctx.node();\n    {3}\n  '}'\n\n  public void apply(Context $ctx) '{'\n    ASTNode $n = $ctx.node();\n{2}\n  '}'\n'}'";
        this.rootAttributeWrite = "$ctx.nt({0}).setValue(\"{1}\", {2});";
        this.rootAttributeRead = "$ctx.nt({0}).getValue(\"{1}\")";
        this.childAttributeWrite = "$ctx.nt({0}).setValue(\"{1}\", {2});";
        this.childAttributeRead = "$ctx.nt({0}).getValue(\"{1}\")";
        this.rootReference = "$n";
        this.childReference = "$ctx.nt({0})";
        this.lexemeReference = "$n.tchild({0}).token";
        this.singletonRead = "$ctx.root().<{0}>getValue(\"${0}\")";
        this.evalStatement = "$ctx.eval({0});";
        this.evalChildren = "$ctx.evalChildren($ctx.nt({0}));";
        this.evalReturn = "$ctx.evalReturn($ctx.nt({0}), \"{1}\")";
        this.suspendStatement = "$ctx.suspend();";
        this.resumeStatement = "$ctx.resume(); return;";
        this.terminateStatement = "throw Blue.Pill;";
        this.setDefaultAction = "$n.setDefaultAction(this, $ctx);";
    }

    @Override
    public String formatSource(String src) {
        Matcher m = multiLineString.matcher(src);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String contents = this.slash(m.group(1));
            String replace = quote + contents.replace("\n", "\\\\n\"+\n\"") + quote;
            m.appendReplacement(sb, this.interpolate(replace));
        }
        m.appendTail(sb);
        return super.formatSource(sb.toString());
    }

    private String interpolate(String input) {
        Matcher m = stringInterpolation.matcher(input);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String contents = m.group(1);
            m.appendReplacement(sb, "\" + (" + contents + ") + " + quote);
        }
        m.appendTail(sb);
        return sb.toString();
    }

    private String slash(String unquoted) {
        return unquoted.replace(quote, "\\\\\"");
    }
}

