/*
 * Decompiled with CFR 0.152.
 */
package neverlang.compiler.mdl;

import dexter.grammar.Symbol;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import neverlang.compiler.UnitHolder;
import neverlang.compiler.mdl.ActionRoleSourceList;
import neverlang.compiler.mdl.SemanticActionSource;
import neverlang.compiler.syn.SyntaxRoleSource;
import neverlang.runtime.ActionMap;
import neverlang.runtime.Module;
import neverlang.runtime.SemanticAction;
import neverlang.runtime.Syntax;
import neverlang.utils.StringUtils;

public class ModuleSource
extends Module {
    private UnitHolder uh;
    private String tpl = "%s\nimport neverlang.runtime.*;\npublic class %s extends Module {\n  public %s() {\n    %s\n%s\n%s\n} \n}";
    private Collection<String> imports = Collections.emptyList();
    boolean unsetCanonicalName = true;
    int temporaryPosCounter = 1;

    public ModuleSource(UnitHolder uh) {
        this.uh = uh;
    }

    public ModuleSource() {
    }

    @Override
    public String getCanonicalName() {
        if (this.unsetCanonicalName) {
            // empty if block
        }
        return super.getCanonicalName();
    }

    public void setCanonicalName(String str) {
        int start;
        this.unsetCanonicalName = false;
        int endpkg = start = str.lastIndexOf(".");
        if (start < 0) {
            start = 0;
            endpkg = 0;
        } else {
            ++start;
        }
        this.name = str.substring(start);
        this.pkgName = str.substring(0, endpkg);
        this.className = str;
        if (this.syntaxrole != null && this.syntaxrole instanceof SyntaxRoleSource) {
            ((SyntaxRoleSource)this.syntaxrole).setModule(this);
        }
    }

    public void setLanguage(String langSpec) {
        Collection actions = this.roleMap.values();
        for (ActionMap am : actions) {
            for (SemanticAction sa : am.values()) {
                SemanticActionSource sas = (SemanticActionSource)sa;
                if (!sas.isDefaultLanguage()) continue;
                sas.setLanguage(langSpec);
            }
        }
    }

    public void setImports(Collection<?> importList) {
        ArrayList<String> list = new ArrayList<String>();
        for (Object importString : importList) {
            list.add(importString.toString());
        }
        this.imports = list;
    }

    public Collection<String> getImports() {
        return this.imports;
    }

    public void setSyntax(Syntax syntax2) {
        this.declareSyntax();
        this.syntaxrole = syntax2;
        if (syntax2 instanceof SyntaxRoleSource) {
            ((SyntaxRoleSource)syntax2).setModule(this);
        }
    }

    @Override
    public void syntaxFrom(String moduleCanonicalName) {
        super.syntaxFrom(moduleCanonicalName);
    }

    int nextTemporaryPosCounter() {
        return this.temporaryPosCounter++;
    }

    void addRoles(String role2, ActionRoleSourceList actionRoleSourceList) {
        if (actionRoleSourceList.isEmpty()) {
            this.addRole(role2);
            return;
        }
        actionRoleSourceList.setRoleName(role2);
        for (SemanticActionSource act : actionRoleSourceList) {
            int _pos = 0;
            _pos = act.hasLabel() ? -this.nextTemporaryPosCounter() : act.getPos();
            this.roleMap.put(act.getRoleName(), _pos, act);
        }
    }

    public void addRole(String role2) {
        this.roleMap.put(role2, new ActionMap());
    }

    public void addRoles(List<String> roles) {
        for (String r : roles) {
            this.addRole(r);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (String roleN : this.roleMap.keySet()) {
            sb.append("    declareRole(\"");
            sb.append(roleN);
            sb.append("\"");
            Collection actions = this.roleMap.get(roleN).values();
            Object[] roleIdsArr = new Integer[actions.size()];
            int k = 0;
            for (SemanticAction act : actions) {
                SemanticActionSource sas = (SemanticActionSource)act;
                roleIdsArr[k++] = sas.getPos();
            }
            Arrays.sort(roleIdsArr);
            Object[] objectArray = roleIdsArr;
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                int i2 = (Integer)objectArray[i];
                sb.append(", ");
                sb.append(i2);
            }
            sb.append(");\n");
        }
        return String.format(this.tpl, this.packageString(), this.getName(), this.getName(), this.getSyntaxDeclaration(), sb.toString(), this.endemicSlicesToString());
    }

    public String getSyntaxDeclaration() {
        String syntaxFrom = this.getSyntaxFrom();
        if (syntaxFrom != null) {
            return "syntaxFrom(\"" + syntaxFrom + "\");";
        }
        return "declareSyntax(); //" + syntaxFrom;
    }

    @Override
    public String[] getRequiredEndemicSlices() {
        HashSet<String> endemics = new HashSet<String>();
        for (String roleN : this.roleMap.keySet()) {
            Collection actions = this.roleMap.get(roleN).values();
            for (SemanticAction action : actions) {
                SemanticActionSource src = (SemanticActionSource)action;
                String[] slices = src.getEndemicSlices();
                endemics.addAll(Arrays.asList(slices));
            }
        }
        return endemics.toArray(new String[0]);
    }

    public String endemicSlicesToString() {
        String[] endemics = this.getRequiredEndemicSlices();
        if (endemics.length == 0) {
            return "";
        }
        return "    requireEndemicSlices(\"" + StringUtils.join(Arrays.asList(endemics), "\", \"") + "\");";
    }

    private String packageString() {
        return this.pkgName.isEmpty() ? "" : "package " + this.pkgName + ";";
    }

    public Map<String, List<Symbol>> getDeclaredCategories() {
        if (this.getSyntaxRole() instanceof SyntaxRoleSource) {
            return ((SyntaxRoleSource)this.getSyntaxRole()).getDeclaredCategories();
        }
        return Collections.emptyMap();
    }
}

