/*
 * Decompiled with CFR 0.152.
 */
package neverlang.compiler.lang;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import neverlang.reflection.VariableInfoEndemic;
import neverlang.runtime.Language;
import neverlang.runtime.LayeredRole;
import neverlang.runtime.Rename;
import neverlang.runtime.Role;
import neverlang.utils.StringUtils;

public class LangSource
extends Language {
    private final String tpl = "%s\n%s\nimport neverlang.runtime.*;\npublic class %s extends %s {\n  public %s() {\n%s\n  } \n}";
    List<List<String>> precedence = new ArrayList<List<String>>();
    List<String> slices;
    List<String> bundles;
    List<String> endemic = Collections.emptyList();
    List<Role> roles = Collections.emptyList();
    private boolean isBundle;
    private boolean isOpen = false;

    public void setIsOpen(boolean isOpen) {
        this.isOpen = isOpen;
    }

    public void setCanonicalName(String str) {
        int start;
        int endpkg = start = str.lastIndexOf(".");
        if (start < 0) {
            start = 0;
            endpkg = 0;
        } else {
            ++start;
        }
        this.name = str.substring(start);
        this.pkgName = str.substring(0, endpkg);
        this.className = str;
    }

    public void addSlices(List<String> idList, List<Boolean> isBundleList) {
        ArrayList<String> sliceList = new ArrayList<String>();
        ArrayList<String> bundleList = new ArrayList<String>();
        for (int i = 0; i < idList.size(); ++i) {
            String idString = idList.get(i);
            if (isBundleList.get(i).booleanValue()) {
                bundleList.add(idString);
                continue;
            }
            sliceList.add(idString);
        }
        this.slices = sliceList;
        this.bundles = bundleList;
    }

    public void addEndemicSlices(List<String> endemicSliceNames) {
        this.endemic = endemicSliceNames;
    }

    public void addRoles(List<Role> roles) {
        this.roles = roles;
    }

    public void addRenames(List<Rename> renames) {
        this.renames = renames;
    }

    public String toString() {
        int i;
        int i2;
        StringBuilder sb = new StringBuilder();
        int n = this.slices.size() - 1;
        sb.append("    importSlices(\n");
        for (i2 = 0; i2 <= n; ++i2) {
            sb.append("     \"");
            sb.append(this.slices.get(i2));
            if (i2 >= n) continue;
            sb.append("\", \n");
        }
        sb.append("\"\n    );\n");
        if (!this.isBundle && !this.bundles.isEmpty()) {
            int nBundles = this.bundles.size() - 1;
            sb.append("    importBundles(\n");
            for (i = 0; i <= nBundles; ++i) {
                sb.append("     \"");
                sb.append(this.bundles.get(i));
                if (i >= nBundles) continue;
                sb.append("\", \n");
            }
            sb.append("\"\n    );\n");
        }
        if (!this.endemic.isEmpty() || this.isOpen) {
            int endN = this.endemic.size() - 1;
            sb.append("    importEndemicSlices(\n");
            if (this.isOpen) {
                sb.append("     \"");
                sb.append(VariableInfoEndemic.class.getName());
                if (!this.endemic.isEmpty()) {
                    sb.append("\", \n");
                }
            }
            for (i = 0; i <= endN; ++i) {
                sb.append("     \"");
                sb.append(this.endemic.get(i));
                if (i >= endN) continue;
                sb.append("\", \n");
            }
            sb.append("\"\n    );\n");
        }
        if (!this.isBundle && this.roles.size() > 0) {
            n = this.roles.size() - 1;
            sb.append("    declare(\n");
            for (i2 = 0; i2 <= n; ++i2) {
                Role r = this.roles.get(i2);
                sb.append("     role(Role.Flags.");
                sb.append((Object)r.flag);
                sb.append(", \"");
                if (r instanceof LayeredRole) {
                    sb.append(StringUtils.join(((LayeredRole)r).roles, "\", \""));
                } else {
                    sb.append(r.getName());
                }
                sb.append("\"");
                if (i2 >= n) continue;
                sb.append("), \n");
            }
            sb.append(")\n    );\n");
        }
        if ((n = this.renames.size() - 1) >= 0) {
            sb.append("    declare(\n");
            for (i2 = 0; i2 <= n; ++i2) {
                Rename r = (Rename)this.renames.get(i2);
                sb.append("     rename(");
                sb.append(String.format("\"%s\", /* <-- */ ", r.to));
                sb.append("\"");
                sb.append(StringUtils.join(Arrays.asList(r.from), "\", \""));
                sb.append("\"");
                if (i2 >= n) continue;
                sb.append("), \n");
            }
            sb.append(")\n    );\n");
        }
        for (List<String> slices : this.precedence) {
            sb.append("    setLeftAssociative(");
            for (int i3 = 0; i3 < slices.size(); ++i3) {
                String slice = slices.get(i3);
                sb.append("\"");
                sb.append(slice);
                sb.append("\"");
                if (i3 >= slices.size() - 1) continue;
                sb.append(",");
            }
            sb.append(");\n");
        }
        String langType = this.isOpen ? "OpenLanguage" : "Language";
        String importOpen = this.isOpen ? "import neverlang.reflection.OpenLanguage;" : "";
        return String.format("%s\n%s\nimport neverlang.runtime.*;\npublic class %s extends %s {\n  public %s() {\n%s\n  } \n}", this.packageString(), importOpen, this.getName(), this.isBundle() ? "Bundle" : langType, this.getName(), sb.toString());
    }

    public void isBundle(boolean isBundle) {
        this.isBundle = isBundle;
    }

    public boolean isBundle() {
        return this.isBundle;
    }

    private String packageString() {
        return this.pkgName.isEmpty() ? "" : "package " + this.pkgName + ";";
    }

    public void addLeftAssociative(List<String> slices) {
        this.precedence.add(slices);
    }
}

