/*
 * Decompiled with CFR 0.152.
 */
package neverlang.compiler.endslc;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import neverlang.runtime.EndemicSlice;
import neverlang.utils.StringUtils;

public class EndemicSliceSource
extends EndemicSlice {
    private String tpl = "%s\nimport neverlang.runtime.*;\npublic class %s extends EndemicSlice {\n  public void declarations() {\n%s\n  }\n  public void staticDeclarations() {\n%s\n  }\n  public String[] getTags() {\n    return new String[] { \"%s\" };\n  }\n\n}";
    private String[] tags = new String[0];

    public void setCanonicalName(String str) {
        int start;
        int endpkg = start = str.lastIndexOf(".");
        if (start < 0) {
            start = 0;
            endpkg = 0;
        } else {
            ++start;
        }
        this.name = str.substring(start);
        this.pkgName = str.substring(0, endpkg);
        this.className = str;
    }

    public void setTags(List<String> tags) {
        this.tags = tags.toArray(this.tags);
    }

    @Override
    public String[] getTags() {
        return this.tags;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        Map<String, Object> instances = this.getDeclaredInstances();
        String declarations = this.instancesToString(instances, DeclarationType.declare);
        String staticDeclarations = this.instancesToString(this.getDeclaredStaticInstances(), DeclarationType.declareStatic);
        String tagString = StringUtils.join(Arrays.asList(this.getTags()), "\", \"");
        return String.format(this.tpl, this.packageString(), this.getName(), declarations, staticDeclarations, tagString);
    }

    private String packageString() {
        return this.pkgName.isEmpty() ? "" : "package " + this.pkgName + ";";
    }

    @Override
    public void declarations() {
    }

    @Override
    public void staticDeclarations() {
    }

    private String instancesToString(Map<String, Object> instances, DeclarationType dt) {
        StringBuilder sb = new StringBuilder();
        for (String interfaceName : instances.keySet()) {
            sb.append("    ").append(dt.toString()).append("(\"");
            sb.append(interfaceName);
            sb.append("\"");
            sb.append(", ");
            sb.append(instances.get(interfaceName));
            sb.append(");\n");
        }
        return sb.toString();
    }

    private static enum DeclarationType {
        declare,
        declareStatic;

    }
}

