/*
 * Decompiled with CFR 0.152.
 */
package neverlang.compiler;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import neverlang.compiler.NeverlangSys;
import neverlang.compiler.UnitWriter;
import neverlang.compiler.mdl.ExceptionGuard;
import neverlang.compiler.mdl.ModuleSource;
import neverlang.compiler.mdl.SemanticActionSource;
import neverlang.compiler.mdl.TypeAnyGuard;
import neverlang.compiler.mdl.TypeGuard;
import neverlang.runtime.ActionMap;
import neverlang.runtime.Module;
import neverlang.runtime.RoleMap;
import neverlang.runtime.SemanticAction;
import neverlang.utils.Tuple;
import org.paukov.combinatorics.Factory;
import org.paukov.combinatorics.Generator;
import org.paukov.combinatorics.ICombinatoricsVector;

public class ModuleWriter
extends UnitWriter {
    Module m;

    public ModuleWriter(Module m, File outDir) {
        super(m);
        this.m = m;
        this.outDir = outDir;
        super.init();
    }

    public void writeModule() throws IOException {
        this.writeSource(this.m.getPackageName(), this.m.getName(), this.m.toString());
    }

    public void writeSyntax() throws IOException {
        if (this.m.getSyntaxFrom() != null) {
            return;
        }
        this.writeSource(this.m.getPackageName(), this.m.getSyntaxRole().getName(), this.m.getSyntaxRole().toString());
    }

    public String[] writeRoles() throws IOException {
        RoleMap rmap = this.m.getRoleMap();
        for (String roleN : rmap.keySet()) {
            ActionMap am = rmap.get(roleN);
            HashMap<Integer, ArrayList<SemanticActionSource>> actions = this.groupActions(am.values(), (ModuleSource)this.m);
            for (Integer i : actions.keySet()) {
                List acts = actions.get(i);
                if (acts.size() == 1) {
                    SemanticActionSource sas = (SemanticActionSource)acts.get(0);
                    if (sas.hasTypeAnyGuard()) {
                        this.writeMultiSemanticAction(this.m, sas);
                        this.processTypeAny(sas, 1);
                        continue;
                    }
                    this.writeFile(this.pkg2path(this.m.getPackageName()), sas.getName(), sas.getFileExtension(), sas.toString());
                    continue;
                }
                int counter = 0;
                SemanticActionSource first = (SemanticActionSource)acts.get(0);
                this.writeMultiSemanticAction(this.m, first);
                for (SemanticActionSource sas : acts) {
                    sas.isSingleAciton(false);
                    if (sas.hasTypeAnyGuard()) {
                        ++counter;
                        counter = this.processTypeAny(sas, counter);
                        continue;
                    }
                    ExceptionGuard exception = sas.getException();
                    if (exception == null) {
                        sas.setNameSuffix(Integer.toString(counter));
                        ++counter;
                    }
                    this.writeFile(this.pkg2path(this.m.getPackageName()), sas.getName(), sas.getFileExtension(), sas.toString());
                }
            }
        }
        ArrayList strings = new ArrayList();
        String[] list = new String[strings.size()];
        strings.toArray(list);
        return list;
    }

    public HashMap<Integer, ArrayList<SemanticActionSource>> groupActions(Collection<SemanticAction> actions, ModuleSource m) {
        HashMap<Integer, ArrayList<SemanticActionSource>> res = new HashMap<Integer, ArrayList<SemanticActionSource>>();
        for (SemanticAction sa : actions) {
            SemanticActionSource sas = (SemanticActionSource)sa;
            String lang = sas.getLanguage();
            sas.setModule(m);
            sas.setLanguageTranslator(NeverlangSys.getTranslator(lang));
            Integer pos = sas.getPos();
            ArrayList<Object> acts = res.containsKey(pos) ? res.get(pos) : new ArrayList();
            if (sas.getPredicate() != null) {
                acts.add(0, sas);
            } else {
                acts.add(sas);
            }
            Collections.sort(acts);
            res.put(pos, acts);
        }
        return res;
    }

    private int processTypeAny(SemanticActionSource sas, int counter) throws IOException {
        TypeAnyGuard guard = sas.getTypeAnyGuard();
        ICombinatoricsVector<Tuple<String, String>> originalVector = Factory.createVector(guard.getConstraints());
        ArrayList nts = new ArrayList();
        ArrayList types = new ArrayList();
        for (int i = 0; i < originalVector.getSize(); ++i) {
            Tuple<String, String> val = originalVector.getValue(i);
            nts.add(val.x);
            types.add(val.y);
        }
        ICombinatoricsVector ntsVector = Factory.createVector(nts);
        Generator ntsGen = Factory.createPermutationGenerator(ntsVector, true);
        ICombinatoricsVector typesVector = Factory.createVector(types);
        Generator typesGen = Factory.createSimpleCombinationGenerator(typesVector, types.size());
        Iterator ntsIterator = ntsGen.iterator();
        ArrayList result = new ArrayList();
        int i = 0;
        while ((long)i < ntsGen.getNumberOfGeneratedObjects()) {
            List list = ((ICombinatoricsVector)ntsIterator.next()).getVector();
            ArrayList perm = new ArrayList();
            for (int j = 0; j < list.size(); ++j) {
                perm.add(new Tuple(list.get(j), types.get(j)));
            }
            result.add(perm);
            ++i;
        }
        for (List list : result) {
            StringBuilder sb = new StringBuilder();
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                Tuple constr = (Tuple)iter.next();
                sb.append(String.format("%s : %s", constr.x, constr.y));
                if (!iter.hasNext()) continue;
                sb.append(" && ");
            }
            TypeGuard typeGuard = new TypeGuard(sb.toString(), guard.getPriority(), guard.isPermanent());
            sas.setPredicate(typeGuard);
            sas.setNameSuffix(Integer.toString(counter));
            this.writeFile(this.pkg2path(this.m.getPackageName()), sas.getName(), sas.getFileExtension(), sas.toString());
            ++counter;
        }
        return counter;
    }

    private void writeMultiSemanticAction(Module m, SemanticActionSource first) throws IOException {
        this.writeFile(this.pkg2path(m.getPackageName()), first.getCleanName(), first.getFileExtension(), MessageFormat.format("package {0};\n\nimport neverlang.runtime.*;\n\npublic class {1} extends MultiSemanticAction '{' '}'", m.getPackageName(), first.getCleanName()));
    }
}

