/*
 * Decompiled with CFR 0.152.
 */
package neverlang.compiler;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import neverlang.compiler.UnitWriter;
import neverlang.compiler.syn.category.Categories;
import neverlang.runtime.Language;

public class CategoryMapperWriter
extends UnitWriter {
    Language language;
    private Collection<Categories> buffer;

    public CategoryMapperWriter(File outDir) {
        super(null);
        this.outDir = outDir;
        super.init();
        this.buffer = new ArrayList<Categories>();
    }

    public void setLanguage(Language lang) throws IOException {
        this.language = lang;
        if (this.language != null && !this.buffer.isEmpty()) {
            for (Categories c : this.buffer) {
                this.writeCategoryMapper(c);
            }
            this.buffer.clear();
        }
    }

    public void writeCategoryMapper(Categories categories) throws IOException {
        if (this.language != null) {
            String packageName = this.language.getCanonicalName().toLowerCase();
            this.writeSource(packageName, categories.getFilename(), categories.dump(packageName));
        } else {
            this.buffer.add(categories);
        }
    }
}

