/*
 * Decompiled with CFR 0.152.
 */
package neverlang.agents.debugger.communication;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.BlockingQueue;
import java.util.logging.Logger;
import neverlang.agents.debugger.commands.AddBreakpointCommand;
import neverlang.agents.debugger.commands.DebugCommand;
import neverlang.agents.debugger.commands.DisconnectCommand;
import neverlang.agents.debugger.commands.GetVariablesCommand;
import neverlang.agents.debugger.commands.RemoveBreakpointCommand;
import neverlang.agents.debugger.commands.ResumeCommand;
import neverlang.agents.debugger.commands.StepIntoCommand;
import neverlang.agents.debugger.commands.StepOverCommand;
import neverlang.agents.debugger.commands.SuspendCommand;
import neverlang.agents.debugger.commands.TerminateCommand;

public class DebugReceiverThread {
    private final ServerSocket channel;
    private Thread thread;

    public DebugReceiverThread(BlockingQueue<DebugCommand> queue, int port) throws IOException {
        this.channel = new ServerSocket(port);
        this.thread = new Thread(new DebugMessageReceiver(queue, this.channel));
    }

    public void start() {
        this.thread.start();
    }

    public void stop() throws IOException {
        this.channel.close();
    }

    private class DebugMessageReceiver
    implements Runnable {
        private final BlockingQueue<DebugCommand> queue;
        private ServerSocket channel;

        public DebugMessageReceiver(BlockingQueue<DebugCommand> queue, ServerSocket channel) {
            this.queue = queue;
            this.channel = channel;
        }

        private DebugCommand parseMessage(String message) {
            if (message.equals("stepinto")) {
                return new StepIntoCommand();
            }
            if (message.equals("disconnect")) {
                return new DisconnectCommand();
            }
            if (message.equals("terminate")) {
                return new TerminateCommand();
            }
            if (message.equals("stepover")) {
                return new StepOverCommand();
            }
            if (message.equals("continue")) {
                return new ResumeCommand();
            }
            if (message.equals("suspend")) {
                return new SuspendCommand();
            }
            if (message.equals("getvariables")) {
                return new GetVariablesCommand();
            }
            String[] tokens = message.split("\\|");
            if (tokens[0].equals("addbreakpoint")) {
                int line = Integer.parseInt(tokens[2]);
                return new AddBreakpointCommand(new File(tokens[1]), line);
            }
            if (tokens[0].equals("removebreakpoint")) {
                int line = Integer.parseInt(tokens[2]);
                return new RemoveBreakpointCommand(new File(tokens[1]), line);
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Socket toDebugClient = null;
            try {
                String msg;
                toDebugClient = this.channel.accept();
                BufferedReader fromEclipse = new BufferedReader(new InputStreamReader(toDebugClient.getInputStream()));
                while ((msg = fromEclipse.readLine()) != null) {
                    DebugCommand command = this.parseMessage(msg.trim());
                    if (command == null) continue;
                    this.queue.put(command);
                }
            }
            catch (InterruptedException e) {
                Logger.getLogger(this.getClass().getName()).severe("Interrupted while adding command to queue");
            }
            catch (IOException e) {
                System.err.println(e);
            }
            finally {
                try {
                    toDebugClient.close();
                    this.channel.close();
                }
                catch (IOException e) {
                    Logger.getLogger(this.getClass().getName()).warning("Error while closing debug channels");
                }
            }
        }
    }
}

