/*
 * Decompiled with CFR 0.152.
 */
package neverlang.agents.debugger.communication;

import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DebugMessageSender {
    private static final String HOST = "localhost";
    private final DataOutputStream toDebugClient;
    private final Socket s = new Socket();

    public DebugMessageSender(int port) throws IOException {
        this.s.connect(new InetSocketAddress(InetAddress.getByName(HOST), port));
        this.toDebugClient = new DataOutputStream(this.s.getOutputStream());
    }

    public void send(String msg) {
        try {
            this.toDebugClient.writeBytes(msg + "\n");
            this.toDebugClient.flush();
        }
        catch (IOException e) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, e);
        }
    }

    public void shutdown() throws IOException {
        this.s.close();
    }
}

