/*
 * Decompiled with CFR 0.152.
 */
package neverlang.agents.debugger.commands;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Logger;
import neverlang.agents.debugger.DebugAgent;
import neverlang.agents.debugger.commands.DebugCommand;
import neverlang.reflection.ValueInfo;
import neverlang.reflection.VariableInfo;

public class GetVariablesCommand
implements DebugCommand {
    @Override
    public void exec(DebugAgent agent) {
        agent.debugSender.send("clearvariables");
        ObjectMapper mapper = new ObjectMapper();
        for (VariableInfo v : agent.getVariables()) {
            try {
                agent.debugSender.send(mapper.writeValueAsString(new SerializedVariableInfo(v)));
            }
            catch (JsonProcessingException e) {
                Logger.getLogger(this.getClass().getName()).severe("Variable serialization failed");
            }
        }
    }

    private class SerializedValueInfo {
        private final ValueInfo valueInfo;

        public SerializedValueInfo(ValueInfo valueInfo) {
            this.valueInfo = valueInfo;
        }

        @JsonProperty(value="type")
        public String type() {
            return this.valueInfo.type();
        }

        @JsonProperty(value="value")
        public String value() {
            return this.valueInfo.value();
        }

        @JsonProperty(value="nestedVars")
        public Collection<SerializedVariableInfo> nestedVars() {
            ArrayList<SerializedVariableInfo> result = new ArrayList<SerializedVariableInfo>();
            for (VariableInfo variableInfo : this.valueInfo.nestedVars()) {
                result.add(new SerializedVariableInfo(variableInfo));
            }
            return result;
        }
    }

    private class SerializedVariableInfo {
        private final VariableInfo variableInfo;

        public SerializedVariableInfo(VariableInfo variableInfo) {
            this.variableInfo = variableInfo;
        }

        @JsonProperty(value="name")
        public String name() {
            return this.variableInfo.name();
        }

        @JsonProperty(value="type")
        public String type() {
            return this.variableInfo.type();
        }

        @JsonProperty(value="value")
        public SerializedValueInfo value() {
            return new SerializedValueInfo(this.variableInfo.value());
        }
    }
}

