/*
 * Decompiled with CFR 0.152.
 */
package neverlang.agents.debugger.breakpoints;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import neverlang.agents.debugger.breakpoints.Breakpoint;
import neverlang.reflection.NodeInfo;

public class BreakpointManager {
    private final Map<File, Set<Breakpoint>> breakpoints = new HashMap<File, Set<Breakpoint>>();

    public boolean hasAssociatedBreakpoint(NodeInfo node) {
        if (node.getFile() == null || !this.breakpoints.containsKey(node.getFile())) {
            return false;
        }
        for (Breakpoint b : this.breakpoints.get(node.getFile())) {
            if (!b.isAssociatedTo(node)) continue;
            return true;
        }
        return false;
    }

    public void addBreakpoint(File file, int line) {
        if (!this.breakpoints.containsKey(file)) {
            this.breakpoints.put(file, new HashSet());
        }
        this.breakpoints.get(file).add(new Breakpoint(file, line));
    }

    public void removeBreakpoint(File file, int line) {
        if (this.breakpoints.containsKey(file)) {
            this.breakpoints.get(file).remove(new Breakpoint(file, line));
        }
    }
}

