/*
 * Decompiled with CFR 0.152.
 */
package neverlang.agents.debugger.breakpoints;

import java.io.File;
import java.util.Objects;
import neverlang.reflection.NodeInfo;

public class Breakpoint {
    private final File file;
    private final int line;

    public Breakpoint(File file, int line) {
        this.file = file;
        this.line = line;
    }

    public boolean isAssociatedTo(NodeInfo node) {
        if (node.getFile() == null) {
            return false;
        }
        return node.getFile().equals(this.file) && node.getLine() == this.line;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Breakpoint that = (Breakpoint)o;
        if (this.line != that.line) {
            return false;
        }
        return this.file.equals(that.file);
    }

    public int hashCode() {
        return Objects.hash(this.file, this.line);
    }
}

