/*
 * Decompiled with CFR 0.152.
 */
package neverlang.agents.debugger;

import java.io.IOException;
import java.rmi.RemoteException;
import java.util.logging.Logger;
import neverlang.agents.debugger.CommandExecutor;
import neverlang.agents.debugger.breakpoints.BreakpointManager;
import neverlang.agents.debugger.communication.DebugMessageSender;
import neverlang.reflection.Agent;
import neverlang.reflection.AnyPattern;
import neverlang.reflection.ExecutionEvent;
import neverlang.reflection.HookType;
import neverlang.reflection.IPatternMatch;
import neverlang.reflection.OpenNeverlang;
import neverlang.reflection.RoleInfo;
import neverlang.reflection.UnregisterAgentException;
import neverlang.reflection.VariableInfo;

public class DebugAgent
extends Agent {
    private State state;
    public BreakpointManager bpManager;
    public DebugMessageSender debugSender;
    private CommandExecutor executor;

    public DebugAgent(OpenNeverlang interpreter, int eclipsePort, int myPort) throws IOException {
        super(interpreter);
        this.executor = new CommandExecutor(this, myPort);
        this.bpManager = new BreakpointManager();
        this.debugSender = new DebugMessageSender(eclipsePort);
        this.debugSender.send("started");
        this.setState(State.INIT);
    }

    public void terminate() {
        try {
            this.debugSender.send("finished");
            this.closeChannels();
            this.interpreter.terminateExecution();
        }
        catch (IOException e) {
            Logger.getLogger(this.getClass().getName()).severe("Error while terminating Neverlang interpreter");
            e.printStackTrace();
        }
    }

    public VariableInfo[] getVariables() {
        try {
            return this.interpreter.getVariableInfos();
        }
        catch (RemoteException e) {
            Logger.getLogger(this.getClass().getName()).severe("Error while communicating with Neverlang interpreter");
            return new VariableInfo[0];
        }
    }

    public void closeChannels() throws IOException {
        this.executor.shutdown();
        this.debugSender.shutdown();
    }

    public synchronized State getState() {
        return this.state;
    }

    public synchronized void setState(State state) {
        this.state = state;
    }

    @Override
    public void before(IPatternMatch iPatternMatch) throws RemoteException {
        if (this.getState() == State.DISCONNECTED) {
            throw new UnregisterAgentException(this);
        }
        this.executor.beforeNode(this.interpreter.getCurrentNode());
    }

    @Override
    public void after(IPatternMatch iPatternMatch) throws RemoteException {
        if (this.getState() == State.DISCONNECTED) {
            throw new UnregisterAgentException(this);
        }
        this.executor.afterNode(this.interpreter.getCurrentNode());
    }

    @Override
    public void interpreterChanged() throws RemoteException {
    }

    @Override
    public void notifyEvent(ExecutionEvent executionEvent) throws RemoteException {
        switch (executionEvent) {
            case FILE_LOADED: {
                RoleInfo[] roleInfoArray = this.interpreter.getRoleInfos();
                int n = roleInfoArray.length;
                int n2 = 0;
                if (n2 >= n) break;
                RoleInfo roleInfo = roleInfoArray[n2];
                String roleName = roleInfo.getName();
                this.interpreter.registerAgent(this, new AnyPattern(), roleName, HookType.BEFORE_AND_AFTER);
                break;
            }
            case EXECUTION_FINISHED: {
                this.terminate();
            }
        }
    }

    public static enum State {
        INIT,
        SUSPENDED,
        RUNNING,
        STEPPING,
        DISCONNECTED;

    }
}

