/*
 * Decompiled with CFR 0.152.
 */
package neverlang.agents.debugger;

import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import neverlang.agents.debugger.DebugAgent;
import neverlang.agents.debugger.commands.DebugCommand;
import neverlang.agents.debugger.commands.StepOverCommand;
import neverlang.agents.debugger.communication.DebugReceiverThread;
import neverlang.reflection.NodeInfo;

public class CommandExecutor {
    private final DebugAgent agent;
    private final BlockingQueue<DebugCommand> commands;
    private final transient DebugReceiverThread receiver;
    private NodeInfo stepOverNode;

    public CommandExecutor(DebugAgent agent, int port) throws IOException {
        this.agent = agent;
        this.commands = new LinkedBlockingQueue<DebugCommand>();
        this.receiver = new DebugReceiverThread(this.commands, port);
        this.receiver.start();
    }

    public void beforeNode(NodeInfo node) {
        this.handleAsyncCommands();
        if (this.suspendAt(node)) {
            this.sendStopEvent(node);
            this.agent.setState(DebugAgent.State.SUSPENDED);
            this.handleSyncCommands(node);
        }
    }

    public void afterNode(NodeInfo node) {
        if (node.equals(this.stepOverNode)) {
            this.agent.setState(DebugAgent.State.STEPPING);
            this.stepOverNode = null;
        }
    }

    public void handleAsyncCommands() {
        DebugCommand command;
        do {
            if ((command = (DebugCommand)this.commands.poll()) == null) continue;
            command.exec(this.agent);
        } while (command != null);
    }

    public void handleSyncCommands(NodeInfo node) {
        do {
            try {
                DebugCommand command = this.commands.take();
                command.exec(this.agent);
                if (!(command instanceof StepOverCommand)) continue;
                this.stepOverNode = node;
            }
            catch (InterruptedException e) {
                Logger.getLogger(DebugAgent.class.getName()).log(Level.SEVERE, null, e);
            }
        } while (this.agent.getState() == DebugAgent.State.SUSPENDED);
    }

    private void sendStopEvent(NodeInfo node) {
        String nodeLocation = node.getFile().getPath() + "|" + String.valueOf(node.getLine());
        if (this.agent.getState() == DebugAgent.State.STEPPING) {
            this.agent.debugSender.send("stepend|" + nodeLocation);
        } else if (this.agent.getState() == DebugAgent.State.SUSPENDED) {
            this.agent.debugSender.send("stopped|" + nodeLocation);
        } else if (this.agent.bpManager.hasAssociatedBreakpoint(node)) {
            this.agent.debugSender.send("breakpoint|" + nodeLocation);
        }
    }

    private boolean suspendAt(NodeInfo node) {
        return this.agent.getState() == DebugAgent.State.INIT || node.isExecutionStep() && (this.agent.getState() == DebugAgent.State.SUSPENDED || this.agent.getState() == DebugAgent.State.STEPPING || this.agent.bpManager.hasAssociatedBreakpoint(node));
    }

    public void shutdown() throws IOException {
        this.receiver.stop();
    }
}

