/*
 * Decompiled with CFR 0.152.
 */
package neverlang;

import dexter.Utils;
import dexter.grammar.Grammar;
import dexter.grammar.Production;
import dexter.grammar.Symbol;
import dexter.grammar.TerminalSym;
import dexter.lexter.RegexTerminalSym;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpecBuilder;
import neverlang.Main;
import neverlang.reflection.ActionInfo;
import neverlang.reflection.HookType;
import neverlang.reflection.IAgent;
import neverlang.reflection.ITreePattern;
import neverlang.reflection.NodeInfo;
import neverlang.reflection.OpenLanguage;
import neverlang.reflection.OpenNeverlang;
import neverlang.reflection.ProductionInfo;
import neverlang.reflection.RoleInfo;
import neverlang.reflection.SliceInfo;
import neverlang.reflection.VariableInfo;
import neverlang.reflection.VariableInfoEndemic;
import neverlang.runtime.Bundle;
import neverlang.runtime.Language;
import neverlang.runtime.dexter.ASTNode;
import neverlang.runtime.dexter.ParsingException;
import neverlang.utils.AnsiColoredString;
import neverlang.utils.FileUtils;
import neverlang.utils.debug.GraphvizAST;

public class Nlgi
implements OpenNeverlang {
    ClassLoader classloader = Thread.currentThread().getContextClassLoader();
    public static boolean COLORIZE_INPUT = Boolean.parseBoolean(System.getenv("NEVERLANG_INPUT_COLORS"));
    Language lang;
    public ASTNode result;
    public boolean multiline;
    public String cwd = ".";
    public long count = 0L;
    public boolean _isOpen = false;
    public String instanceName = "Nlgi";
    public PrintStream out;
    private final String[] args;
    private String languageCanonicalName;
    private static final String CLEARLINE = "\u001b[1A\u001b[2K";
    private static final Pattern alnum = Pattern.compile("^[a-zA-Z]+$");

    public static void main(String[] args) throws Exception {
        try {
            Nlgi nlgi = new Nlgi(args);
            nlgi.parseArgs();
            nlgi.setOut(System.out);
            nlgi.setCwd(new File(".").getAbsolutePath() + "/");
            if (nlgi.isOpen()) {
                if (System.getSecurityManager() == null) {
                    System.setSecurityManager(new SecurityManager());
                }
                OpenNeverlang stub = (OpenNeverlang)UnicastRemoteObject.exportObject((Remote)nlgi, 0);
                Registry registry = LocateRegistry.getRegistry();
                registry.rebind(nlgi.instanceName, stub);
                nlgi.out.println("Interpreter instance bound as: " + nlgi.instanceName);
            }
            nlgi.main();
        }
        catch (Exception e) {
            e.printStackTrace();
            if (Main.DEMO_MODE) {
                e.printStackTrace();
            }
            throw e;
        }
    }

    public String readLine(String format, Object ... args) throws IOException {
        String input;
        if (System.console() != null) {
            input = System.console().readLine(format, args);
            if (COLORIZE_INPUT) {
                this.colorize(input);
            }
        } else {
            this.out.print(String.format(format, args));
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            input = reader.readLine();
        }
        if (input != null) {
            return input.trim();
        }
        return null;
    }

    private void colorize(String input) {
        if (input == null || input.isEmpty()) {
            return;
        }
        this.out.print(CLEARLINE);
        if (this.multiline) {
            this.out.print(AnsiColoredString.RedString("| "));
        } else {
            this.out.print(AnsiColoredString.RedString("> "));
        }
        List<TerminalSym> terminals = this.lang.getDexter().getLexter().getTerminals();
        for (TerminalSym t : terminals) {
            if (t instanceof RegexTerminalSym || !alnum.matcher(t.toString()).matches()) continue;
            input = input.replace(t.toString(), AnsiColoredString.BlueString(t.toString()).toString());
        }
        this.out.println(input);
    }

    private void printUsage(OptionParser p) throws IOException {
        System.out.println("USAGE: nlgi [options] <LangSubclass>\n");
        p.printHelpOn(System.out);
        System.exit(0);
    }

    public void parseArgs() {
        OptionParser parser = new OptionParser();
        OptionSpecBuilder help = parser.acceptsAll(Arrays.asList("h", "?", "help"), "Show this help message");
        ArgumentAcceptingOptionSpec<File> classpath = parser.acceptsAll(Arrays.asList("cp", "classpath"), "A '" + File.pathSeparator + "' delimited list of directories, JAR archives and ZIP archives used to look for a class file").withRequiredArg().ofType(File.class).withValuesSeparatedBy(File.pathSeparatorChar).describedAs("classpath");
        OptionSpecBuilder colorize = parser.accepts("c", "Colorize user input");
        OptionSpecBuilder xNoOrderedMap = parser.accepts("XNoOrderedMap", "Uses a simple HashMap instead of a LinkedHashMap for slice storage");
        ArgumentAcceptingOptionSpec<String> open = parser.acceptsAll(Arrays.asList("o", "open"), "Allows one to dynamically change the behavior of the interpreter (based on RMI).").withRequiredArg().ofType(String.class);
        ArgumentAcceptingOptionSpec<String> attachTo = parser.accepts("n", "").withRequiredArg().ofType(String.class);
        OptionSpecBuilder events = parser.accepts("e", "Enables (file-system based) event notifications. Warning: a monitor-coordinator application is required to coordinate the execution.");
        OptionSet opts = parser.parse(this.args);
        try {
            if (opts.has(colorize)) {
                COLORIZE_INPUT = true;
            }
            if (opts.has(help)) {
                this.printUsage(parser);
            }
            if (opts.nonOptionArguments().isEmpty()) {
                this.printUsage(parser);
                System.exit(1);
            }
            List<?> allArgs = opts.nonOptionArguments();
            this.languageCanonicalName = (String)allArgs.get(0);
            if (opts.has(classpath)) {
                this.setClasspath(opts.valuesOf(classpath));
            }
            if (opts.has(xNoOrderedMap)) {
                Bundle.USE_ORDERED_HASHMAP = false;
            }
            if (opts.has(open)) {
                this.setIsOpen(true);
                this.instanceName = opts.valueOf(open);
            }
            Class<?> langClass = this.classloader.loadClass(this.languageCanonicalName);
            this.lang = (Language)langClass.newInstance();
            if (opts.has(attachTo)) {
                this.lang.setInstanceName(opts.valueOf(attachTo));
            }
            if (opts.has(events)) {
                this.lang.enableEventNotifications(true);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private void setClasspath(List<File> valuesOf) {
        URL[] urls = new URL[valuesOf.size()];
        for (int i = 0; i < urls.length; ++i) {
            try {
                urls[i] = valuesOf.get(i).toURI().toURL();
                continue;
            }
            catch (MalformedURLException ex) {
                Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.classloader = new URLClassLoader(urls, ClassLoader.getSystemClassLoader());
        Thread.currentThread().setContextClassLoader(this.classloader);
    }

    public void setIsOpen(boolean isOpen) {
        this._isOpen = isOpen;
    }

    public boolean isOpen() throws RemoteException {
        return this._isOpen;
    }

    public void checkIfOpen() throws RemoteException {
        if (!this._isOpen) {
            throw new RemoteException("Language implementation is not open.");
        }
    }

    public boolean execInternalCommand(String input) throws Exception {
        if ((input = input.trim()).indexOf(":") != 0) {
            return false;
        }
        input = input.substring(1);
        switch (input.charAt(0)) {
            case 'q': {
                this.exit();
                break;
            }
            case 'r': {
                this.reload();
                break;
            }
            case 'h': {
                this.printHelp();
                break;
            }
            case 'g': {
                this.printGrammar();
                break;
            }
            case 'e': {
                this.dumpEndemic();
                break;
            }
            case 't': {
                this.dumpTree();
                break;
            }
            case 'm': {
                this.toggleMultiline();
                break;
            }
            case 'p': {
                this.dumpParser();
            }
        }
        return true;
    }

    public void printHelp() {
        this.out.println();
        this.out.println("Available Commands:\n:help      :h\tGet this screen\n:quit      :q\tLeave Repl\n:reload    :r\tReload the language implementation from disk\n:tree      :t\tDump last parse tree as a Graphviz source file\n:parser    :p\tDump parser to disk\n:endemic   :e\tDump Endemic Slices\n:grammar   :g\tDump language grammar\n:multiline :m\tToggle multiline input\n");
    }

    public void printWelcomeMessage(String langCanonicalName) {
        this.out.println("----------------------------------------");
        this.out.println("NLGi. Neverlang Interactive REPL.");
        this.out.printf("Using Neverlang RSD Compiler %d.%d.%d\n", 0, 8, 0);
        try {
            File jarFile = new File(this.getClass().getProtectionDomain().getCodeSource().getLocation().toURI());
            this.out.println("Compiled on: " + new Date(jarFile.lastModified()) + "\n");
        }
        catch (URISyntaxException e1) {
            this.out.println("Compiled on: unknwon.\n");
        }
        this.out.print("Language ");
        this.out.println(langCanonicalName);
        this.printHelp();
    }

    public void printGrammar() {
        this.out.printf("Grammar for %s\n\n", this.lang.getCanonicalName());
        Grammar g = this.lang.getDexter().grammar;
        int pad = this.getPadding(g.keySet());
        for (Production p : g.getProductions()) {
            this.out.printf("%1$-" + pad + "s\t", p.nt);
            this.out.printf(" <-- %s\n", this.prettyPrintSymbols(p.body));
        }
    }

    public String prettyPrintSymbols(List<Symbol> body) {
        StringBuilder sb = new StringBuilder();
        for (Symbol s : body) {
            if (s instanceof TerminalSym) {
                sb.append("'");
                sb.append(s.toString());
                sb.append("'");
            } else {
                sb.append(s.toString());
            }
            sb.append(" ");
        }
        return sb.toString();
    }

    public void exit() {
        this.out.println("Leaving NLGi.");
        System.exit(0);
    }

    public void reload() throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        Reloader reloader = new Reloader(this.classloader);
        Thread.currentThread().setContextClassLoader(reloader);
        this.lang = (Language)((ClassLoader)reloader).loadClass(this.languageCanonicalName).newInstance();
        this.out.println("Language " + this.languageCanonicalName + " reloaded.");
    }

    public void dumpEndemic() {
        if (this.result == null) {
            this.out.println();
            return;
        }
        HashMap<String, Object> results = this.result.getValues();
        int pad = this.getPadding(results.keySet());
        String padder = "%1$-" + pad + "s\t";
        for (String k : results.keySet()) {
            this.out.printf(padder, k);
            this.out.println(results.get(k));
        }
        this.out.println();
    }

    public void dumpTree() throws FileNotFoundException {
        if (this.result == null) {
            return;
        }
        String fname = this.lang.getCanonicalName() + "-" + this.count + ".tree.dot";
        String fpath = this.cwd + fname;
        FileUtils.stringToFile(new GraphvizAST(this.result).toString(), fpath);
        this.out.println("Parse tree saved to " + fpath);
    }

    public int getPadding(Collection<? extends Object> results) {
        int max = 0;
        for (Object object : results) {
            int l = object.toString().length();
            if (max >= l) continue;
            max = l;
        }
        return max;
    }

    public String readInput() throws IOException {
        String lastInput;
        String prompt = "> ";
        if (!this.multiline) {
            return this.readLine(prompt, new Object[0]);
        }
        StringBuilder inputB = new StringBuilder();
        do {
            lastInput = this.readLine(prompt, new Object[0]);
            inputB.append(lastInput);
            if (lastInput.length() > 0 && lastInput.charAt(0) == ':') {
                return lastInput;
            }
            inputB.append("\n");
            prompt = "| ";
        } while (lastInput.length() > 0);
        String result = inputB.toString();
        this.out.println();
        if (result.trim().length() == 0) {
            return "";
        }
        return result;
    }

    public void toggleMultiline() {
        this.multiline = !this.multiline;
        this.out.print("Multiline input ");
        this.out.println(this.multiline ? "enabled. " : "disabled. ");
    }

    public void dumpParser() throws FileNotFoundException {
        String fname = this.lang.getCanonicalName() + ".parser.dot";
        String gvDump = Utils.getGVdump(this.lang.getDexter());
        String fpath = this.cwd + fname;
        FileUtils.stringToFile(gvDump, fpath);
        this.out.println("Parser DFA saved to " + fpath);
    }

    public Nlgi(String[] args) {
        this.args = args;
    }

    public Nlgi(Language lang) {
        this.lang = lang;
        this.args = new String[0];
    }

    public void main() throws IOException {
        this.printWelcomeMessage(this.lang.getCanonicalName());
        while (true) {
            this.out.println();
            String input = this.readInput();
            this.processInput(input);
        }
    }

    public void processInput(String input) {
        try {
            if (input == null) {
                this.exit();
                return;
            }
            if (input.isEmpty()) {
                return;
            }
            if (this.execInternalCommand(input)) {
                return;
            }
            ++this.count;
            this.result = this.lang.exec(input);
        }
        catch (ParsingException ex) {
            Collection<TerminalSym> expectedSymbols = ex.getExpectedSymbols();
            if (expectedSymbols.isEmpty()) {
                this.out.printf("Parse error at %d:%d. Reachable symbols were: %s. Did you forget to define a nonterminal?\n", ex.getUnexpectedSymbol().row, ex.getUnexpectedSymbol().col, this.symbolCollectionToString(ex.getState().goTo.keySet()), this.symbolCollectionToString(expectedSymbols));
            } else {
                this.out.printf("Parse error at %d:%d. Found %s, expected %s.\n", ex.getUnexpectedSymbol().row, ex.getUnexpectedSymbol().col, ex.getUnexpectedSymbol(), this.symbolCollectionToString(expectedSymbols));
            }
        }
        catch (Throwable ex) {
            this.result = this.lang.getDexter().getLastParseTree();
            if (!Main.DEMO_MODE) {
                ex.printStackTrace();
            }
            this.out.println("Warning: caught internal error.");
        }
    }

    public String symbolCollectionToString(Collection<? extends Symbol> coll) {
        StringBuilder sb = new StringBuilder();
        int sz_1 = coll.size() - 1;
        if (sz_1 < 0) {
            return "";
        }
        Iterator<? extends Symbol> iter = coll.iterator();
        for (int i = 0; i < sz_1; ++i) {
            sb.append(iter.next()).append(", ");
        }
        sb.append(iter.next());
        return sb.toString();
    }

    public void setOut(PrintStream out) {
        this.out = out;
    }

    public void setCwd(String string) {
        this.cwd = string;
    }

    @Override
    public ProductionInfo[] getGrammar() throws RemoteException {
        this.checkIfOpen();
        return ((OpenLanguage)this.lang).getGrammar();
    }

    @Override
    public RoleInfo[] getRoleInfos() throws RemoteException {
        this.checkIfOpen();
        return ((OpenLanguage)this.lang).getRoleInfos();
    }

    @Override
    public VariableInfo[] getVariableInfos() throws RemoteException {
        this.checkIfOpen();
        return VariableInfoEndemic.VariableInfoManager.getInstance().getVariables().toArray(new VariableInfo[0]);
    }

    @Override
    public void registerAgent(IAgent agent, ITreePattern pattern, String roleName, HookType htype) throws RemoteException {
        this.checkIfOpen();
        ((OpenLanguage)this.lang).registerAgent(agent, pattern, roleName, htype);
    }

    @Override
    public ProductionInfo getCurrentProduction() throws RemoteException {
        this.checkIfOpen();
        return ((OpenLanguage)this.lang).getCurrentProduction();
    }

    @Override
    public NodeInfo getCurrentNode() throws RemoteException {
        this.checkIfOpen();
        return ((OpenLanguage)this.lang).getCurrentNode();
    }

    @Override
    public void replaceSlice(SliceInfo oldSlice, SliceInfo newSlice) throws RemoteException {
        this.checkIfOpen();
        ((OpenLanguage)this.lang).replaceSlice(oldSlice.getSliceCanonicalName(), newSlice.getSliceCanonicalName());
    }

    @Override
    public void redoRole(String roleName) throws RemoteException {
        this.checkIfOpen();
        ((OpenLanguage)this.lang).redoRole(roleName);
    }

    @Override
    public void setDefaultAction(ActionInfo actionInfo, NodeInfo nodeInfo, String role2) throws RemoteException {
        this.checkIfOpen();
        ((OpenLanguage)this.lang).setDefaultAction(actionInfo, nodeInfo, role2);
    }

    @Override
    public void terminateExecution() throws RemoteException {
        this.exit();
    }

    @Override
    public void registerAgentForChanges(IAgent agent) throws RemoteException {
        throw new RemoteException();
    }

    @Override
    public void addActionToNode(ActionInfo actionInfo, NodeInfo nodeInfo, String addToRole) throws RemoteException {
        this.checkIfOpen();
        ((OpenLanguage)this.lang).addActionToNode(actionInfo, nodeInfo, addToRole);
    }

    @Override
    public void removeActionFromNode(ActionInfo actionInfo, NodeInfo nodeInfo, String fromRole) throws RemoteException {
        this.checkIfOpen();
        ((OpenLanguage)this.lang).removeActionFromNode(actionInfo, nodeInfo, fromRole);
    }

    class Reloader
    extends ClassLoader {
        ClassLoader delegateClassLoader;

        Reloader(ClassLoader orig) {
            this.delegateClassLoader = orig;
        }

        @Override
        public Class<?> loadClass(String s) {
            return this.findClass(s);
        }

        @Override
        public Class<?> findClass(String s) {
            try {
                byte[] bytes = this.loadClassData(s);
                return this.defineClass(s, bytes, 0, bytes.length);
            }
            catch (IOException ioe) {
                try {
                    return super.loadClass(s);
                }
                catch (ClassNotFoundException ignore) {
                    ignore.printStackTrace(System.out);
                    ioe.printStackTrace(System.out);
                    return null;
                }
            }
        }

        private byte[] loadClassData(String className) throws IOException {
            try {
                Class<?> clazz = this.delegateClassLoader.loadClass(className);
                URL url = clazz.getResource(clazz.getSimpleName() + ".class");
                File f = new File(url.toURI());
                int size = (int)f.length();
                byte[] buff = new byte[size];
                FileInputStream fis = new FileInputStream(f);
                DataInputStream dis = new DataInputStream(fis);
                dis.readFully(buff);
                dis.close();
                return buff;
            }
            catch (Exception ex) {
                throw new IOException(ex);
            }
        }
    }
}

