/*
 * Decompiled with CFR 0.152.
 */
package neverlang;

import dexter.grammar.TerminalSym;
import dexter.lexter.QualifiedToken;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import neverlang.GenericMain;
import neverlang.Main;
import neverlang.Nlgi;
import neverlang.reflection.ActionInfo;
import neverlang.reflection.AgentInitializer;
import neverlang.reflection.ExecutionEvent;
import neverlang.reflection.HookType;
import neverlang.reflection.IAgent;
import neverlang.reflection.ITreePattern;
import neverlang.reflection.NodeInfo;
import neverlang.reflection.OpenLanguage;
import neverlang.reflection.OpenNeverlang;
import neverlang.reflection.ProductionInfo;
import neverlang.reflection.RoleInfo;
import neverlang.reflection.SliceInfo;
import neverlang.reflection.VariableInfo;
import neverlang.reflection.VariableInfoEndemic;
import neverlang.runtime.Bundle;
import neverlang.runtime.Language;
import neverlang.runtime.dexter.ASTNode;
import neverlang.runtime.dexter.ParsingException;
import neverlang.utils.StringUtils;

public class Nlg
extends GenericMain
implements OpenNeverlang {
    ClassLoader classloader = Thread.currentThread().getContextClassLoader();
    Language lang;
    public String attachTo = null;
    private boolean _isOpen = false;
    public String instanceName = "Nlgi";
    private Collection<IAgent> notifyOnChangeAgents = new ArrayList<IAgent>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        block15: {
            Nlg m = null;
            try {
                m = new Nlg(args);
                m.parseArgs();
                if (m.getFilePaths().isEmpty()) {
                    Nlgi nlgi = new Nlgi(args);
                    nlgi.parseArgs();
                    nlgi.setOut(System.out);
                    nlgi.setCwd(new File(".").getAbsolutePath() + "/");
                    if (nlgi.isOpen()) {
                        if (System.getSecurityManager() == null) {
                            System.setSecurityManager(new SecurityManager());
                        }
                        OpenNeverlang stub = (OpenNeverlang)UnicastRemoteObject.exportObject((Remote)nlgi, 0);
                        Registry registry = LocateRegistry.getRegistry();
                        registry.rebind(nlgi.instanceName, stub);
                        nlgi.out.println("Interpreter instance bound as: " + nlgi.instanceName);
                    }
                    nlgi.main();
                } else {
                    m.readFiles();
                    if (m.isOpen()) {
                        if (System.getSecurityManager() == null) {
                            System.setSecurityManager(new SecurityManager());
                        }
                        OpenNeverlang stub = (OpenNeverlang)UnicastRemoteObject.exportObject((Remote)m, 0);
                        Registry registry = LocateRegistry.getRegistry();
                        registry.rebind(m.instanceName, stub);
                        System.out.println("Interpreter instance bound as: " + m.instanceName);
                    }
                    try {
                        m.processFiles();
                    }
                    catch (ParsingException e) {
                        TerminalSym unexpSym = e.getUnexpectedSymbol().getSymbol();
                        System.err.println(String.format("%d:%d: Unexpected %s. Expected: %s.\n", e.getUnexpectedSymbol().row, e.getUnexpectedSymbol().col, Nlg.printTerminalSymbol(e.getUnexpectedSymbol()), Nlg.printTerminalSymbols(e.getExpectedSymbols())));
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (Main.DEMO_MODE) {
                    System.err.println(e.getMessage());
                    break block15;
                }
                throw e;
            }
            finally {
                if (m != null) {
                    m.notifyAgents(ExecutionEvent.EXECUTION_FINISHED);
                }
            }
        }
    }

    private Nlg(String[] args) {
        this.args = args;
    }

    @Override
    public void processFiles() {
        for (int i = 0; i < this.fileList.size(); ++i) {
            String fname = (String)this.filePaths.get(i);
            String src = (String)this.fileList.get(i);
            ASTNode t = this.lang.parse(src, new File(fname));
            this.notifyAgents(ExecutionEvent.FILE_LOADED);
            t = this.lang.exec(t);
        }
    }

    private void notifyAgents(ExecutionEvent executionEvent) {
        for (IAgent agent : this.notifyOnChangeAgents) {
            try {
                agent.notifyEvent(executionEvent);
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void parseArgs() {
        OptionParser parser = new OptionParser();
        OptionSpecBuilder help = parser.acceptsAll(Arrays.asList("h", "?", "help"), "Show this help message");
        ArgumentAcceptingOptionSpec<String> agents = parser.accepts("agents", "A '" + File.pathSeparatorChar + "' delimited list of agents to attach at startup").withRequiredArg().ofType(String.class).withValuesSeparatedBy(File.pathSeparatorChar);
        ArgumentAcceptingOptionSpec<String> agentsArgs = parser.accepts("agents-args", "A '" + File.pathSeparatorChar + "' delimited list of ',' separated lists of arguments to initialize agents").withRequiredArg().ofType(String.class).withValuesSeparatedBy(File.pathSeparatorChar);
        ArgumentAcceptingOptionSpec<File> classpath = parser.acceptsAll(Arrays.asList("cp", "classpath"), "A '" + File.pathSeparator + "' delimited list of directories, JAR archives and ZIP archives used to look for a class file").withRequiredArg().ofType(File.class).withValuesSeparatedBy(File.pathSeparatorChar).describedAs("classpath");
        OptionSpecBuilder xNoOrderedMap = parser.accepts("XNoOrderedMap", "Uses a simple HashMap instead of a LinkedHashMap for slice storage");
        ArgumentAcceptingOptionSpec<String> open = parser.acceptsAll(Arrays.asList("o", "open"), "Allows one to dynamically change the behavior of the interpreter (based on RMI).").withRequiredArg().ofType(String.class);
        ArgumentAcceptingOptionSpec<String> attachTo = parser.accepts("n", "").withRequiredArg().ofType(String.class);
        OptionSet opts = parser.parse(this.args);
        List<?> allArgs = opts.nonOptionArguments();
        if (allArgs.size() == 1) {
            return;
        }
        if (allArgs.isEmpty() || allArgs.size() < 2) {
            this.printUsage(parser);
            System.exit(1);
        }
        String languageCanonicalName = (String)allArgs.get(0);
        this.filePaths = allArgs.subList(1, allArgs.size());
        if (opts.has(classpath)) {
            this.setClasspath(opts.valuesOf(classpath));
        }
        if (opts.has(xNoOrderedMap)) {
            Bundle.USE_ORDERED_HASHMAP = false;
        }
        if (opts.has(open)) {
            this.setIsOpen(true);
            this.instanceName = opts.valueOf(open);
        }
        if (opts.has(agents)) {
            this.initializeAgents(agents, agentsArgs, opts);
        }
        try {
            Class<?> langClass = this.classloader.loadClass(languageCanonicalName);
            this.lang = (Language)langClass.newInstance();
            this.lang.reduceTree(true);
            if (opts.has(attachTo)) {
                this.lang.setInstanceName(opts.valueOf(attachTo));
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private void initializeAgents(OptionSpec<String> agents, OptionSpec<String> agentsArgs, OptionSet opts) {
        List<String> agentInitializers = opts.valuesOf(agents);
        List<String> agentArgs = opts.valuesOf(agentsArgs);
        if (agentInitializers.size() > 1 && agentInitializers.size() != agentArgs.size()) {
            System.err.println("Too few arguments given for initial agents");
            System.exit(1);
        }
        for (int i = 0; i < agentInitializers.size(); ++i) {
            Class<?> agentInitializer = null;
            try {
                agentInitializer = Class.forName(agentInitializers.get(i));
            }
            catch (ClassNotFoundException e) {
                System.err.println("Class " + agentInitializers.get(i) + " not found");
                System.exit(1);
            }
            if (!AgentInitializer.class.isAssignableFrom(agentInitializer)) {
                System.err.println("Invalid agent initializer class " + agentInitializer);
                System.exit(1);
            }
            try {
                AgentInitializer a = (AgentInitializer)agentInitializer.newInstance();
                a.init(this, agentArgs.get(i).split(","));
                continue;
            }
            catch (IllegalAccessException | InstantiationException | RuntimeException e) {
                System.err.println("Unable to initialize agent initializer " + agentInitializer);
                e.printStackTrace();
                System.exit(1);
            }
        }
    }

    private static String printTerminalSymbol(TerminalSym s) {
        if (s instanceof QualifiedToken) {
            QualifiedToken t = (QualifiedToken)s;
            TerminalSym x = t.getSymbol();
            String text = t.text;
            return String.format("%s: '%s'", x, text);
        }
        return "symbol '" + s.toString() + '\'';
    }

    private static String printTerminalSymbols(Collection<TerminalSym> ss) {
        ArrayList<String> l = new ArrayList<String>();
        for (TerminalSym s : ss) {
            l.add(Nlg.printTerminalSymbol(s));
        }
        return StringUtils.join(l, ", ");
    }

    private void printUsage(OptionParser p) {
        System.out.println("nlg [options] <LangSubclass> file1 file2 ...\n");
        try {
            p.printHelpOn(System.out);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void setClasspath(List<File> valuesOf) {
        URL[] urls = new URL[valuesOf.size()];
        for (int i = 0; i < urls.length; ++i) {
            try {
                urls[i] = valuesOf.get(i).toURI().toURL();
                continue;
            }
            catch (MalformedURLException ex) {
                Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.classloader = new URLClassLoader(urls, ClassLoader.getSystemClassLoader());
        Thread.currentThread().setContextClassLoader(this.classloader);
    }

    public void setIsOpen(boolean isOpen) {
        this._isOpen = isOpen;
    }

    public boolean isOpen() {
        return this._isOpen;
    }

    public void checkIfOpen() throws RemoteException {
        if (!this._isOpen) {
            throw new RemoteException("Language implementation is not open.");
        }
    }

    @Override
    public ProductionInfo[] getGrammar() throws RemoteException {
        this.checkIfOpen();
        return ((OpenLanguage)this.lang).getGrammar();
    }

    @Override
    public RoleInfo[] getRoleInfos() throws RemoteException {
        this.checkIfOpen();
        return ((OpenLanguage)this.lang).getRoleInfos();
    }

    @Override
    public VariableInfo[] getVariableInfos() throws RemoteException {
        this.checkIfOpen();
        return VariableInfoEndemic.VariableInfoManager.getInstance().getVariables().toArray(new VariableInfo[0]);
    }

    @Override
    public void registerAgent(IAgent agent, ITreePattern pattern, String roleName, HookType htype) throws RemoteException {
        this.checkIfOpen();
        ((OpenLanguage)this.lang).registerAgent(agent, pattern, roleName, htype);
    }

    @Override
    public ProductionInfo getCurrentProduction() throws RemoteException {
        this.checkIfOpen();
        return ((OpenLanguage)this.lang).getCurrentProduction();
    }

    @Override
    public NodeInfo getCurrentNode() throws RemoteException {
        this.checkIfOpen();
        return ((OpenLanguage)this.lang).getCurrentNode();
    }

    @Override
    public void replaceSlice(SliceInfo oldSlice, SliceInfo newSlice) throws RemoteException {
        this.checkIfOpen();
        ((OpenLanguage)this.lang).replaceSlice(oldSlice.getSliceCanonicalName(), newSlice.getSliceCanonicalName());
    }

    @Override
    public void redoRole(String roleName) throws RemoteException {
        this.checkIfOpen();
        ((OpenLanguage)this.lang).redoRole(roleName);
    }

    @Override
    public void setDefaultAction(ActionInfo actionInfo, NodeInfo nodeInfo, String role2) throws RemoteException {
        this.checkIfOpen();
        ((OpenLanguage)this.lang).setDefaultAction(actionInfo, nodeInfo, role2);
    }

    @Override
    public void terminateExecution() throws RemoteException {
        this.checkIfOpen();
        UnicastRemoteObject.unexportObject(this, true);
        System.exit(0);
    }

    @Override
    public void registerAgentForChanges(IAgent agent) throws RemoteException {
        this.checkIfOpen();
        this.notifyOnChangeAgents.add(agent);
    }

    @Override
    public void addActionToNode(ActionInfo actionInfo, NodeInfo nodeInfo, String addToRole) throws RemoteException {
        this.checkIfOpen();
        ((OpenLanguage)this.lang).addActionToNode(actionInfo, nodeInfo, addToRole);
    }

    @Override
    public void removeActionFromNode(ActionInfo actionInfo, NodeInfo nodeInfo, String fromRole) throws RemoteException {
        this.checkIfOpen();
        ((OpenLanguage)this.lang).removeActionFromNode(actionInfo, nodeInfo, fromRole);
    }
}

