/*
 * Decompiled with CFR 0.152.
 */
package dexter.utils;

import java.util.Collection;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;

public class VisitableSet<T>
extends HashSet<T> {
    private Set<T> visitedStates = new HashSet<T>();

    public VisitableSet() {
    }

    public VisitableSet(T s) {
        this();
        this.add(s);
    }

    public VisitableSet(Collection<? extends T> es) {
        super(es);
    }

    public T visitNext() {
        for (Object nextState : this) {
            if (this.visitedStates.contains(nextState)) continue;
            this.visitedStates.add(nextState);
            return (T)nextState;
        }
        throw new NoSuchElementException();
    }

    public boolean hasMore() {
        return this.visitedStates.size() < this.size();
    }

    public VisitableSet<T> getClone() {
        return new VisitableSet<T>(this);
    }

    @Override
    public boolean add(T s) {
        if (s != null) {
            return super.add(s);
        }
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends T> es) {
        if (es == null) {
            return false;
        }
        boolean retVal = false;
        for (T s : es) {
            retVal |= this.add(s);
        }
        return retVal;
    }
}

