/*
 * Decompiled with CFR 0.152.
 */
package dexter.parser;

import dexter.grammar.Grammar;
import dexter.grammar.NonTerminalSym;
import dexter.grammar.Symbol;
import dexter.parser.Item;
import dexter.parser.ParserState;
import dexter.utils.StateItemLookup;
import dexter.utils.StateSet;
import dexter.utils.StateSymbolLookup;
import java.io.Serializable;

public class ParserStateFactory
implements Serializable {
    private static final long serialVersionUID = 7359927710450066638L;
    private int idFactory = 0;
    public final StateItemLookup instances = new StateItemLookup();
    public final StateSymbolLookup stateSymbolLookup = new StateSymbolLookup();

    private int getNewId() {
        return ++this.idFactory;
    }

    public void reset() {
        this.stateSymbolLookup.clear();
        this.instances.clear();
    }

    public StateSet getStates() {
        StateSet states = new StateSet();
        for (Item k : this.instances.keySet()) {
            states.addAll(this.instances.get(k));
        }
        return states;
    }

    public StateSet getStateFromSymbol(NonTerminalSym s) {
        try {
            return this.stateSymbolLookup.get(s).getClone();
        }
        catch (NullPointerException e) {
            System.err.println("Warning: you are adding a pending rule.");
            return new StateSet();
        }
    }

    public void setSymbolForState(NonTerminalSym s, ParserState st) {
        StateSet set = this.stateSymbolLookup.get(s);
        if (set == null) {
            set = new StateSet();
        }
        set.add(st);
        this.stateSymbolLookup.put(s, set);
    }

    public ParserState summonNextState(Item itm, ParserState currentState, Grammar g) {
        ParserState next = null;
        StateSet stateSet = this.getStates(itm);
        if (stateSet.isEmpty()) {
            next = new ParserState(this.getNewId(), this);
            next.addToKernel(itm);
            stateSet.add(next);
            return next;
        }
        for (ParserState state : stateSet) {
            if (!currentState.implies(state, g)) continue;
            return state;
        }
        next = new ParserState(this.getNewId(), this);
        next.addToKernel(itm);
        stateSet.add(next);
        return next;
    }

    public StateSet getStates(Item itm) {
        return this.instances.get(itm);
    }

    public void updateState(ParserState s, Item itm) {
        StateSet states = this.instances.get(itm);
        s.addToKernel(itm);
        Symbol dottedSymbol = itm.getSymbolAtPos();
        if (dottedSymbol instanceof NonTerminalSym) {
            this.setSymbolForState((NonTerminalSym)dottedSymbol, s);
        }
        states.add(s);
        this.instances.put(itm, states);
    }

    public void removeState(ParserState s, Item itm) {
        s.removeFromKernel(itm);
        StateSet states = this.instances.get(itm);
        if (states == null) {
            return;
        }
        if (states.contains(s)) {
            states.remove(s);
        }
    }
}

