/*
 * Decompiled with CFR 0.152.
 */
package dexter.parser;

import dexter.grammar.Grammar;
import dexter.grammar.NonTerminalSym;
import dexter.grammar.Production;
import dexter.grammar.Symbol;
import dexter.grammar.TerminalSym;
import dexter.parser.DynamicParserException;
import dexter.parser.ITokenStream;
import dexter.parser.Item;
import dexter.parser.Kernel;
import dexter.parser.LookaheadSet;
import dexter.parser.ParserStateFactory;
import dexter.parser.ReduceReduceConflictException;
import dexter.parser.SymbolMap;
import dexter.parser.UnexpectedSymbolException;
import dexter.parser.ast.NodeStack;
import dexter.utils.NoSuchTransitionException;
import dexter.utils.StateSet;
import dexter.utils.VisitableSet;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class ParserState
implements Serializable,
Comparable<ParserState> {
    private static final long serialVersionUID = -726712837196883923L;
    protected static int count = -1;
    public ParserStateFactory stateFactory;
    protected final int id;
    public final Kernel kernel = new Kernel();
    public SymbolMap goTo = new SymbolMap();
    public Item reduceBy = null;
    protected int debug = 0;
    private boolean invalid = false;
    private boolean dirty = true;
    private Conflict conflicting = null;

    protected void dprint(Object s) {
        if (this.debug > 0) {
            System.out.println(s);
        }
    }

    protected ParserState(int id, ParserStateFactory factory) {
        this.id = id;
        this.stateFactory = factory;
        this.dprint("New state: " + this);
    }

    void addToKernel(Item idItem) {
        if (idItem.getSymbolAtPos() == null) {
            if (this.reduceBy != null && !this.reduceBy.equals(idItem)) {
                if (!this.kernel.contains(idItem)) {
                    this.conflicting = Conflict.ReduceReduce;
                }
            } else {
                this.reduceBy = idItem.prev();
            }
        }
        this.kernel.add(idItem);
    }

    public void removeFromKernel(Item idItem) {
        if (this.kernel.contains(idItem)) {
            this.dprint("KERN:" + idItem);
            this.kernel.remove(idItem);
            if (idItem.getSymbolAtPos() == null) {
                for (Item _idItem : this.kernel) {
                    if (idItem.getSymbolAtPos() != null) continue;
                    this.reduceBy = _idItem.prev();
                }
            }
        }
    }

    public int getId() {
        return this.id;
    }

    public int hashCode() {
        return this.id;
    }

    public void mergeWith(ParserState that) {
        this.dprint(this + " merges with " + that);
        for (Symbol trans : that.goTo.keySet()) {
            ParserState thisNextState;
            ParserState thatNextState = (ParserState)that.goTo.get(trans);
            if (!thatNextState.equals(thisNextState = (ParserState)this.goTo.get(trans))) {
                System.out.println(String.format("Conflicting transitions for symbol %s in states #%d and #%d (#%d vs #%d) -- first was chosen", trans, this.getId(), that.getId(), thisNextState.getId(), thatNextState.getId()));
            }
            this.goTo.setTransition(trans, thisNextState);
        }
        that.invalidate();
    }

    public boolean equals(Object obj) {
        this.dprint("EQUALS");
        return ((ParserState)obj).id == this.id;
    }

    public String toString() {
        return "State #" + this.getId();
    }

    public boolean isTerminalState() {
        return this.kernel.getCandidates().size() > 0;
    }

    public Set<Item> closure(Item itm, Grammar grammar) {
        HashSet<Item> s = new HashSet<Item>();
        s.add(itm);
        return this.closure(s, grammar);
    }

    public Set<Item> closure(Item itm, Grammar grammar, Set<Item> itemClosure) {
        HashSet<Item> s = new HashSet<Item>();
        s.add(itm);
        this.closure(s, grammar, itemClosure);
        return itemClosure;
    }

    public Set<Item> closure(Collection<Item> itemSet, Grammar grammar) {
        HashSet<Item> itemClosure = new HashSet<Item>();
        this.closure(itemSet, grammar, itemClosure);
        return itemClosure;
    }

    public Set<Item> closure(Collection<Item> itemSet, Grammar grammar, Set<Item> itemClosure) {
        for (Item item : itemSet) {
            itemClosure.add(item);
            if (item.isCandidate() || item.getSymbolAtPos() instanceof TerminalSym) continue;
            NonTerminalSym nt = (NonTerminalSym)item.getSymbolAtPos();
            ArrayList<Item> itemList = new ArrayList<Item>();
            Iterator iterator = grammar.get(nt).iterator();
            while (iterator.hasNext()) {
                Production p = (Production)iterator.next();
                Item newItem = p.toItem();
                if (itemClosure.contains(newItem)) continue;
                itemList.add(newItem);
            }
            this.closure(itemList, grammar, itemClosure);
        }
        return itemClosure;
    }

    public Set<Item> _closure(Collection<Item> itemSet, Grammar grammar, Set<Item> itemClosure) {
        VisitableSet<Item> queue = new VisitableSet<Item>();
        for (Item idItem : itemSet) {
            if (idItem.isCandidate()) continue;
            queue.add(idItem);
        }
        if (queue.isEmpty()) {
            return queue;
        }
        do {
            NonTerminalSym nt;
            Object prods;
            Item itm = queue.visitNext();
            itemClosure.add(itm);
            Symbol cursorSym = itm.getSymbolAtPos();
            if (cursorSym == null) {
                throw new RuntimeException("Symbol found to be NULL");
            }
            if (!(cursorSym instanceof NonTerminalSym) || (prods = grammar.get(nt = (NonTerminalSym)cursorSym)) == null) continue;
            Iterator iterator = prods.iterator();
            while (iterator.hasNext()) {
                Production p = (Production)iterator.next();
                Item newItm = p.toItem();
                if (itemClosure.contains(newItm)) continue;
                queue.add(newItm);
            }
        } while (queue.hasMore());
        return itemClosure;
    }

    StateSet visit(Grammar grammar) {
        this.dprint("VISITING:" + this.getId());
        StateSet newStates = new StateSet();
        for (Item kernelItem : this.kernel) {
            for (Item nonkernelItm : this.closure(kernelItem, grammar)) {
                newStates.add(this.findState(grammar, nonkernelItm));
            }
            newStates.add(this.findState(grammar, kernelItem));
        }
        this.dprint("END VISIT:" + this.getId());
        return newStates;
    }

    private ParserState findState(Grammar grammar, Item itm) {
        this.stateFactory.setSymbolForState(itm.nt, this);
        if (itm.isCandidate()) {
            return null;
        }
        Symbol currentSymbol = itm.getSymbolAtPos();
        ParserState nextState = null;
        try {
            nextState = this.goTo.getTransition(currentSymbol);
            this.dprint("update " + nextState + " " + itm);
            this.stateFactory.updateState(nextState, itm.next());
        }
        catch (NoSuchTransitionException e) {
            this.dprint("NoSuchTransition:" + currentSymbol);
            nextState = this.stateFactory.summonNextState(itm.next(), this, grammar);
            this.dprint("summoned " + nextState + " " + itm);
            this.goTo.setTransition(currentSymbol, nextState);
        }
        return nextState;
    }

    public boolean implies(ParserState next, Grammar grammar) {
        for (Item nextIdItm : next.kernel) {
            if (this.kernel.contains(nextIdItm.prev()) || this.nonKernelContains(nextIdItm.prev(), grammar)) continue;
            return false;
        }
        return true;
    }

    public boolean nonKernelContains(Item item, Grammar grammar) {
        if (item.isKernel()) {
            return false;
        }
        Symbol s = null;
        Object prods = null;
        HashSet<Symbol> q = new HashSet<Symbol>();
        HashSet<Symbol> v = new HashSet<Symbol>();
        for (Item tmp : this.kernel) {
            q.add(tmp.getSymbolAtPos());
        }
        do {
            s = (Symbol)q.iterator().next();
            q.remove(s);
            prods = grammar.get(s);
            v.add(s);
            if (prods == null) continue;
            Iterator<Item> iterator = prods.iterator();
            while (iterator.hasNext()) {
                Production p = iterator.next();
                Symbol ns = (Symbol)p.body.get(0);
                if (ns instanceof NonTerminalSym && !v.contains(ns)) {
                    q.add(ns);
                }
                if (!item.equals(p.toItem().next())) continue;
                return true;
            }
        } while (!q.isEmpty());
        return false;
    }

    public StateSet removeItem(Item targetItem, Grammar g) throws NoSuchTransitionException {
        this.dprint(this);
        if (targetItem.isKernel()) {
            this.removeFromKernel(targetItem);
        }
        StateSet result = new StateSet();
        Set<Item> targetClosure = this.closure(targetItem, g);
        targetClosure.removeAll(this.closure(this.kernel, g));
        this.dprint(targetClosure);
        for (Item itm : targetClosure) {
            Symbol currentSymbol;
            if (itm.isCandidate() || !this.goTo.hasTransition(currentSymbol = itm.getSymbolAtPos())) continue;
            ParserState nextState = this.goTo.getTransition(currentSymbol);
            if (nextState.kernel.size() == 1) {
                this.goTo.delTransition(currentSymbol);
                this.dprint("removing:" + currentSymbol + "->" + nextState);
                continue;
            }
            this.dprint("it must be ITM==TARGETITEM, else skip");
            if (itm != targetItem) continue;
            result.add(nextState);
        }
        return result;
    }

    public void updateLookahead() {
    }

    public Item getHighestScoreCandidate() {
        Item max = this.kernel.getCandidates().get(0);
        for (Item i : this.kernel.getCandidates()) {
            if (max.getScore() >= i.getScore()) continue;
            max = i;
        }
        return max;
    }

    public Item reduce(Symbol tokenSym) {
        List<Item> candidates = this.kernel.getCandidates();
        if (candidates.size() == 1) {
            return candidates.get(0).prev();
        }
        for (Item candidate : candidates) {
            LookaheadSet la = this.kernel.getLookahead(candidate);
            if (!la.contains(tokenSym)) continue;
            return candidate.prev();
        }
        throw new ReduceReduceConflictException(candidates);
    }

    /*
     * Enabled aggressive block sorting
     */
    public Item parse(ITokenStream tokens, NodeStack stack) {
        TerminalSym tokenSym;
        block11: {
            tokenSym = tokens.peek();
            if (this.isTerminalState()) {
                Item firstCandidate = this.kernel.getCandidates().get(0);
                if (firstCandidate.isRightAssociative()) {
                    return this.reduce(tokenSym);
                }
                System.out.println("1");
                int candidateScore = firstCandidate.getScore();
                boolean doReduce = true;
                for (Item i : this.kernel.getNonCandidates()) {
                    if (i.getScore() <= candidateScore) continue;
                    System.out.println("2");
                    doReduce = false;
                    break;
                }
                System.out.println("3");
                if (doReduce) {
                    return this.reduce(tokenSym);
                }
                System.out.println("4");
            }
            if (!this.goTo.containsKey(tokenSym)) {
                if (this.goTo.containsKey(Grammar.EPSILON)) {
                    tokenSym = Grammar.EPSILON;
                    break block11;
                } else {
                    if (!this.isTerminalState()) throw new UnexpectedSymbolException(tokenSym, this.goTo.getTerminalSymbols(), this);
                    return this.reduce(tokenSym);
                }
            }
            tokens.getNext();
        }
        stack.push(tokenSym);
        Item reduceByRule = ((ParserState)this.goTo.get(tokenSym)).parse(tokens, stack);
        NonTerminalSym reduceByNT = reduceByRule.nt;
        if (reduceByRule.pos == 0) {
            stack.reduce(reduceByRule.toProduction());
        }
        while (!reduceByRule.isKernel()) {
            if (!this.goTo.containsKey(reduceByNT)) {
                throw new DynamicParserException("Could not reduce by " + reduceByNT + " " + this.goTo + " in " + this.toString());
            }
            reduceByRule = ((ParserState)this.goTo.get(reduceByNT)).parse(tokens, stack);
            reduceByNT = reduceByRule.nt;
            if (reduceByRule.pos != 0) continue;
            stack.reduce(reduceByRule.toProduction());
        }
        return reduceByRule.prev();
    }

    @Override
    public int compareTo(ParserState arg0) {
        return this.id - arg0.id;
    }

    public void invalidate() {
        this.invalid = true;
    }

    public boolean isInvalid() {
        return this.invalid;
    }

    public void setDirty() {
        this.dirty = true;
    }

    public void toggleDirty() {
        this.dirty = !this.dirty;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean hasConflicts() {
        return this.conflicting != null;
    }

    public Conflict getConflictType() {
        return this.conflicting;
    }

    public static enum Conflict {
        ShiftReduce,
        ReduceReduce;

    }
}

