/*
 * Decompiled with CFR 0.152.
 */
package dexter.parser;

import dexter.grammar.Grammar;
import dexter.grammar.NonTerminalSym;
import dexter.grammar.Production;
import dexter.grammar.Symbol;
import dexter.parser.Item;
import dexter.parser.LookaheadUpdater;
import dexter.parser.ParserState;
import dexter.parser.ParserStateFactory;
import dexter.utils.NoSuchTransitionException;
import dexter.utils.StateSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class Graph
extends ParserState {
    Grammar g;
    public int counter = 0;

    protected Graph(Grammar g) {
        super(0, new ParserStateFactory());
        this.g = g;
    }

    public static Graph newGraph(Grammar g) {
        return new Graph(g);
    }

    public void setStart() {
        ++this.counter;
        Item idItem = this.g.getStart().toItem();
        this.kernel.add(idItem);
        this.kernel.getLookahead(idItem).add(Grammar.EOF);
        StateSet s = new StateSet();
        s.add(this);
        this.stateFactory.stateSymbolLookup.put((NonTerminalSym)idItem.body.get(0), s);
    }

    public void update(Production p, Grammar g) {
        ++this.counter;
        this.dprint("UPD:" + p);
        StateSet states = new StateSet(this);
        this.update(states, g);
    }

    public void update(ParserState s, Grammar g) {
        this.update(new StateSet(s), g);
    }

    public void update(StateSet states, Grammar g) {
        this.dprint(states);
        while (states.hasMore()) {
            ParserState newState = (ParserState)states.visitNext();
            StateSet updatedStates = newState.visit(g);
            this.dprint(updatedStates);
            states.addAll(updatedStates);
        }
        StateSet inconsistentStates = this.checkConsistency(g);
        if (!inconsistentStates.isEmpty()) {
            this.update(inconsistentStates, g);
        }
    }

    public void remove(Production p, StateSet states, Grammar grammar) {
        ++this.counter;
        StateSet neighbors = new StateSet();
        StateSet history = new StateSet(states);
        Item targetItem = p.toItem();
        while (targetItem.pos <= targetItem.body.size()) {
            this.dprint("RMV:" + states);
            while (states.hasMore()) {
                ParserState currentState = (ParserState)states.visitNext();
                try {
                    neighbors.addAll(currentState.removeItem(targetItem, grammar));
                }
                catch (NoSuchTransitionException e) {
                    System.err.println(e + ", state #" + currentState.getId());
                    return;
                }
            }
            targetItem = targetItem.next();
            states = new StateSet(neighbors);
            history.addAll(neighbors);
            neighbors.clear();
        }
        this.coalesceDuplicates(history);
    }

    private ParserState mergeStates(ParserState s1, ParserState s2) {
        if (s1.getId() < s2.getId()) {
            s1.mergeWith(s2);
            return s1;
        }
        s2.mergeWith(s1);
        return s2;
    }

    private void coalesceDuplicates(final StateSet targetCollection) {
        this.breadthFirstVisit(new Visitor(){

            @Override
            public void visit(ParserState s) {
                HashMap<Symbol, ParserState> mergedTransitions = new HashMap<Symbol, ParserState>();
                for (Symbol trans : s.goTo.keySet()) {
                    for (ParserState target : targetCollection) {
                        ParserState nextState = (ParserState)s.goTo.get(trans);
                        if (nextState.getId() == target.getId() || !nextState.kernel.equals(target.kernel)) continue;
                        mergedTransitions.put(trans, Graph.this.mergeStates(nextState, target));
                    }
                }
                for (Symbol trans : mergedTransitions.keySet()) {
                    System.err.println("set transition " + trans + " for #" + s.getId() + " to #" + ((ParserState)mergedTransitions.get(trans)).getId());
                    s.goTo.setTransition(trans, (ParserState)mergedTransitions.get(trans));
                }
            }
        });
    }

    private StateSet checkConsistency(final Grammar grammar) {
        this.dprint("! initiating consistency routine");
        final StateSet inconsistentStates = new StateSet();
        this.breadthFirstVisit(new Visitor(){

            @Override
            public void visit(ParserState s) {
                HashSet badTransitions = new HashSet();
                for (Map.Entry e : s.goTo.entrySet()) {
                    ParserState next = (ParserState)e.getValue();
                    if (s.implies(next, grammar)) continue;
                    Graph.this.dprint(s.getId() + " does not imply " + next.getId());
                    inconsistentStates.add(s);
                    badTransitions.add(e.getKey());
                }
                for (Symbol target : badTransitions) {
                    s.goTo.delTransition(target);
                }
            }
        });
        this.dprint("! consistency check ended");
        return inconsistentStates;
    }

    public void updateLookahead(Grammar g) {
        LookaheadUpdater updater = new LookaheadUpdater(g);
        do {
            this.dprint("DOING PASS");
            updater.dirty = false;
            this.breadthFirstVisit(updater);
        } while (updater.dirty);
    }

    public void breadthFirstVisit(Visitor v) {
        StateSet states = new StateSet(this);
        while (states.hasMore()) {
            ParserState s = (ParserState)states.visitNext();
            v.visit(s);
            for (Symbol sym : s.goTo.keySet()) {
                ParserState newState = (ParserState)s.goTo.get(sym);
                states.add(newState);
            }
        }
    }

    public String dump() {
        this.debug = 0;
        Visitor v = new Visitor(){
            String out = "";

            @Override
            public void visit(ParserState s) {
                this.out = this.out + s.kernel.toString() + "\n  GOTO:" + s.goTo.toString() + "\n";
            }

            public String toString() {
                return this.out;
            }
        };
        this.breadthFirstVisit(v);
        return v.toString();
    }

    public int getUpdateCount() {
        return this.counter;
    }

    public static interface Visitor {
        public void visit(ParserState var1);
    }
}

