/*
 * Decompiled with CFR 0.152.
 */
package dexter.lexter.utils;

import dexter.grammar.NonTerminalSym;
import dexter.grammar.Production;
import dexter.grammar.SimpleTerminalSym;
import dexter.grammar.Symbol;
import dexter.lexter.KeywordTerminalSym;
import dexter.lexter.Lexter;
import dexter.lexter.RegexTerminalSym;

public class Conversions {
    public static Production implicitTerminals(Production p, Lexter lexer) {
        return Conversions.implicitTerminals(p.nt, p.body.toArray(), lexer, p.getLabel(), p.isRightAssociative(), p.getScore());
    }

    public static Production implicitTerminals(NonTerminalSym nt, Object[] symbols, Lexter lexer, String label, boolean isRightAssociative, int score) {
        Symbol[] body = new Symbol[symbols.length];
        for (int i = 0; i < symbols.length; ++i) {
            SimpleTerminalSym ts;
            Object sym = symbols[i];
            if (sym instanceof String) {
                ts = new KeywordTerminalSym((String)sym);
                body[i] = ts;
                lexer.add(ts, (String)sym);
                continue;
            }
            if (sym instanceof KeywordTerminalSym) {
                ts = (KeywordTerminalSym)sym;
                lexer.add((KeywordTerminalSym)ts);
                body[i] = ts;
                continue;
            }
            if (sym instanceof RegexTerminalSym) {
                ts = (RegexTerminalSym)sym;
                lexer.add((RegexTerminalSym)ts);
                body[i] = ts;
                continue;
            }
            body[i] = (Symbol)sym;
        }
        Production p = new Production(nt, body);
        p.setRightAssociative(isRightAssociative);
        p.setScore(score);
        return p.setLabel(label);
    }

    public static RegexTerminalSym asRegex(String s) {
        return new RegexTerminalSym(s);
    }

    public static RegexTerminalSym asRegex(String name, String r) {
        return new RegexTerminalSym(name, r);
    }

    public static KeywordTerminalSym asKeyword(String s) {
        return new KeywordTerminalSym(s);
    }
}

