/*
 * Decompiled with CFR 0.152.
 */
package dexter.lexter;

import dexter.grammar.Grammar;
import dexter.grammar.TerminalSym;
import dexter.lexter.KeywordMatch;
import dexter.lexter.KeywordTerminalSym;
import dexter.lexter.QualifiedToken;
import dexter.lexter.RegexTerminalSym;
import dexter.lexter.UnexpectedTerminalSym;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Lexter {
    HashSet<TerminalSym> terminals = new HashSet();
    List<RegexTerminalSym> patternList = new ArrayList<RegexTerminalSym>();
    List<KeywordTerminalSym> keywordList = new ArrayList<KeywordTerminalSym>();
    List<RegexTerminalSym> skipPatternList = new ArrayList<RegexTerminalSym>();
    HashSet<TerminalSym> trylast = new HashSet();
    int pointer;
    int row;
    int col;
    String input;
    String[] lines;
    Pattern skip = Pattern.compile("\\s+");
    private QualifiedToken qualifiedEOF;
    Pattern newLines = Pattern.compile("\r\n|\r|\n");

    public void setInput(String input) {
        this.pointer = 0;
        this.row = 0;
        this.col = 0;
        this.input = input;
        this.lines = input.split("\r\n|\r|\n");
        this.skip = Pattern.compile(this.joinSkipPatterns());
        this.qualifiedEOF = new QualifiedToken(Grammar.EOF, Grammar.EOF.toString(), this.lines.length, this.lines[this.lines.length - 1].length(), new KeywordMatch("")){

            @Override
            public String toString() {
                return Grammar.EOF.toString();
            }
        };
    }

    private String joinSkipPatterns() {
        if (this.skipPatternList.isEmpty()) {
            return this.skip.toString();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        int size = this.skipPatternList.size();
        for (int i = 0; i < size - 1; ++i) {
            RegexTerminalSym s = this.skipPatternList.get(i);
            sb.append(s.getPattern().toString());
            sb.append("|");
        }
        sb.append(this.skipPatternList.get(size - 1).getPattern().toString());
        sb.append(")*");
        return sb.toString();
    }

    public Lexter add(RegexTerminalSym r) {
        this.patternList.add(r);
        this.terminals.add(r);
        return this;
    }

    public Lexter add(KeywordTerminalSym s) {
        this.keywordList.add(s);
        this.terminals.add(s);
        return this;
    }

    public Lexter addKeyword(String k) {
        KeywordTerminalSym s = new KeywordTerminalSym(k);
        this.keywordList.add(s);
        this.terminals.add(s);
        return this;
    }

    public Lexter addRegex(String regex) {
        RegexTerminalSym s = new RegexTerminalSym(regex);
        this.patternList.add(s);
        this.terminals.add(s);
        return this;
    }

    public Lexter addSkip(String regex) {
        RegexTerminalSym s = new RegexTerminalSym(regex);
        this.skipPatternList.add(s);
        this.terminals.add(s);
        return this;
    }

    @Deprecated
    public Lexter add(TerminalSym tokenId, String regex) {
        this.patternList.add(new RegexTerminalSym(tokenId, regex));
        this.terminals.add(tokenId);
        return this;
    }

    @Deprecated
    public Lexter addLast(TerminalSym tokenId, String regex) {
        this.trylast.add(tokenId);
        this.add(tokenId, regex);
        return this;
    }

    private int countNewlinesB(String sourceString) {
        if (sourceString == null) {
            return -1;
        }
        int count = 0;
        for (int i = 0; i < sourceString.length(); ++i) {
            char c = sourceString.charAt(i);
            if (c != '\n') continue;
            ++count;
        }
        return count;
    }

    public int countNewlines(String source) {
        Matcher m = this.newLines.matcher(source);
        int lines = 0;
        while (m.find()) {
            ++lines;
        }
        return lines;
    }

    private boolean updatePointers(String token) {
        int sizeOfToken = token.length();
        int nLines = this.countNewlines(token);
        this.pointer += sizeOfToken;
        if (nLines > 0) {
            this.row += nLines;
            if (token.lastIndexOf(10) == -1) {
                --this.row;
            }
            this.col = token.length() - token.lastIndexOf(10);
        } else {
            this.col += token.length();
        }
        return false;
    }

    public TerminalSym getNextToken() {
        ArrayList<TerminalSym> list = new ArrayList<TerminalSym>(this.keywordList);
        list.addAll(this.patternList);
        return this.getNextToken(list);
    }

    public TerminalSym getNextToken(Collection<TerminalSym> terminalSyms) {
        String currentSubstring;
        if (this.pointer >= this.input.length()) {
            return this.qualifiedEOF;
        }
        try {
            boolean repeat;
            do {
                repeat = false;
                currentSubstring = this.input.substring(this.pointer);
                Matcher mskip = this.skip.matcher(currentSubstring);
                if (!mskip.lookingAt()) continue;
                this.updatePointers(mskip.group());
            } while (repeat);
        }
        catch (IllegalStateException repeat) {
            // empty catch block
        }
        if (this.pointer >= this.input.length()) {
            return this.qualifiedEOF;
        }
        currentSubstring = this.input.substring(this.pointer);
        int longestMatchLen = 0;
        CharSequence longestMatchStr = null;
        TerminalSym longestMatchSym = null;
        Matcher longestMatchMatcher = null;
        boolean hasEpsilon = false;
        if (terminalSyms.removeAll(this.trylast)) {
            terminalSyms.addAll(this.trylast);
        }
        for (TerminalSym tokenId : terminalSyms) {
            if (tokenId == Grammar.EPSILON) {
                hasEpsilon = true;
                continue;
            }
            if (tokenId instanceof RegexTerminalSym) {
                CharSequence matched;
                int l;
                Matcher m = ((RegexTerminalSym)tokenId).getPattern().matcher(currentSubstring);
                if (!m.lookingAt() || (l = (matched = currentSubstring.subSequence(0, m.end())).length()) <= longestMatchLen) continue;
                longestMatchLen = l;
                longestMatchStr = matched;
                longestMatchSym = tokenId;
                longestMatchMatcher = m;
                continue;
            }
            String keyword = tokenId.toString();
            if (!currentSubstring.startsWith(keyword) || keyword.length() < longestMatchLen) continue;
            longestMatchLen = keyword.length();
            longestMatchStr = keyword;
            longestMatchSym = tokenId;
            longestMatchMatcher = null;
        }
        if (longestMatchLen > 0) {
            QualifiedToken tok = new QualifiedToken(longestMatchSym, longestMatchStr.toString(), this.row + 1, this.col, longestMatchMatcher != null ? longestMatchMatcher.toMatchResult() : new KeywordMatch(longestMatchStr.toString()));
            this.updatePointers(longestMatchStr.toString());
            return tok;
        }
        if (hasEpsilon) {
            return new QualifiedEpsilon(this.row, this.col);
        }
        int lastrow = this.row;
        int lastcol = this.col;
        if (this.input.length() >= this.pointer) {
            String unknownTokenString = currentSubstring.split("\\s")[0];
            return new QualifiedToken(new UnexpectedTerminalSym(unknownTokenString), unknownTokenString, this.row + 1, this.col + 1, new KeywordMatch(unknownTokenString));
        }
        return this.qualifiedEOF;
    }

    public List<TerminalSym> getTerminals() {
        return new ArrayList<TerminalSym>(this.terminals);
    }

    class QualifiedEpsilon
    extends QualifiedToken {
        QualifiedEpsilon(int row, int col) {
            super(Grammar.EPSILON, "", row, col, new KeywordMatch(""));
        }

        @Override
        public boolean equals(Object that) {
            return this.hashCode() == that.hashCode();
        }

        @Override
        public int hashCode() {
            return Grammar.EPSILON.hashCode();
        }
    }
}

