/*
 * Decompiled with CFR 0.152.
 */
package dexter.grammar;

import dexter.grammar.IProductionBody;
import dexter.grammar.NonTerminalSym;
import dexter.grammar.ProductionBody;
import dexter.grammar.Symbol;
import dexter.grammar.TerminalSym;
import dexter.parser.Item;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Production
implements Serializable {
    public final int hashCode;
    private final String toString;
    private static final long serialVersionUID = -106775795114796030L;
    public final NonTerminalSym nt;
    public final IProductionBody body;
    public String label;
    protected int score;
    private boolean rightAssociative = true;

    public int getNonterminalLength() {
        int count = 0;
        for (Symbol s : this.body) {
            if (!(s instanceof NonTerminalSym)) continue;
            ++count;
        }
        return count + 1;
    }

    private int generateHashCode() {
        int result = 1;
        int prime = 3;
        result = 3 * result + this.nt.hashCode();
        result = 3 * result + this.body.hashCode();
        return 3 * result;
    }

    private String generateToString() {
        return this.nt.toString() + " --> " + this.body.toString();
    }

    public int getScore() {
        return this.score;
    }

    public Production setScore(int score) {
        this.score = score;
        return this;
    }

    public Production(NonTerminalSym nt, IProductionBody body) {
        this.nt = nt;
        this.body = body;
        this.hashCode = this.generateHashCode();
        this.toString = this.generateToString();
    }

    public Production(NonTerminalSym nt, Symbol ... body) {
        this.nt = nt;
        this.body = new ProductionBody(body);
        this.hashCode = this.generateHashCode();
        this.toString = this.generateToString();
    }

    public Production(NonTerminalSym nt, Collection<? extends Symbol> c) {
        this.nt = nt;
        this.body = new ProductionBody(c.toArray(new Symbol[0]));
        this.hashCode = this.generateHashCode();
        this.toString = this.generateToString();
    }

    public List<NonTerminalSym> getNonterminals() {
        ArrayList<NonTerminalSym> nts = new ArrayList<NonTerminalSym>();
        nts.add(this.nt);
        for (Symbol s : this.body) {
            if (s instanceof TerminalSym) continue;
            nts.add((NonTerminalSym)s);
        }
        return nts;
    }

    public Production setLabel(String lab) {
        this.label = lab;
        return this;
    }

    public Production setRightAssociative(boolean associative) {
        this.rightAssociative = associative;
        return this;
    }

    public Production setRightAssociative() {
        return this.setRightAssociative(true);
    }

    public boolean isRightAssociative() {
        return this.rightAssociative;
    }

    public String getLabel() {
        return this.label;
    }

    public Item toItem() {
        Item i = new Item(this, 0);
        i.setLabel(this.getLabel());
        i.setRightAssociative(this.isRightAssociative());
        i.setScore(this.getScore());
        return i;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Production) {
            return ((Production)obj).hashCode == this.hashCode;
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return this.toString;
    }
}

