/*
 * Decompiled with CFR 0.152.
 */
package dexter.grammar;

import dexter.grammar.FirstTable;
import dexter.grammar.NonTerminalSym;
import dexter.grammar.NullableSymbolSet;
import dexter.grammar.Production;
import dexter.grammar.ProductionSet;
import dexter.grammar.ReverseNTLookup;
import dexter.grammar.SimpleNonTerminalSym;
import dexter.grammar.SimpleTerminalSym;
import dexter.grammar.Symbol;
import dexter.grammar.TerminalSym;
import java.util.HashSet;

public class Grammar
extends ProductionSet {
    private static final long serialVersionUID = -7107317990102398890L;
    Production start;
    public static NonTerminalSym START = new SimpleNonTerminalSym("[START]");
    public static TerminalSym EPSILON = new TerminalSym(){

        @Override
        public int hashCode() {
            return Integer.MAX_VALUE;
        }

        public String toString() {
            return "\u03b5";
        }
    };
    public static TerminalSym EOF = new SimpleTerminalSym("$", -1);
    public FirstTable firstTable = new FirstTable(this);
    public NullableSymbolSet nullables = new NullableSymbolSet(this);
    ReverseNTLookup reverseLookup = new ReverseNTLookup();

    public Grammar() {
        super(new Production[0]);
    }

    public Production setStart(NonTerminalSym s) {
        Production oldStart = this.start;
        this.start = new Production(START, s, EOF);
        return oldStart;
    }

    public Production getStart() {
        return this.start;
    }

    public NonTerminalSym getAxiom() {
        return (NonTerminalSym)this.start.body.get(0);
    }

    @Override
    public void put(Production p) {
        HashSet<Production> b = super.get(p.nt);
        if (b.isEmpty()) {
            b = new HashSet<Production>();
            this.put(p.nt, b);
        }
        b.add(p);
        for (Symbol s : p.body) {
            if (!(s instanceof NonTerminalSym)) continue;
            this.reverseLookup.put((NonTerminalSym)s, p.nt);
        }
    }

    public boolean contains(Production p) {
        try {
            return super.get(p.nt).contains(p);
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    public void remove(Production p) throws ProductionNotFoundException {
        Object b = super.get(p.nt);
        if (null == b || !b.contains(p)) {
            throw new ProductionNotFoundException(p);
        }
        b.remove(p);
    }

    @Override
    public String toString() {
        String s = this.getStart() + "\n";
        for (Production p : this.getProductions()) {
            s = s + p.nt + "\u2192" + p.body.toString() + "\n";
        }
        return s;
    }

    public String toGVString() {
        String s = "Grammar [ style = \"filled\" penwidth = 1 fillcolor = \"white\" fontname = \"Courier New\" shape = \"Mrecord\" , label =<<table border=\"0\" cellborder=\"0\" cellpadding=\"3\" bgcolor=\"white\"><tr><td bgcolor=\"black\" align=\"center\" colspan=\"2\"><font color=\"white\">Grammar</font></td></tr>";
        for (Production p : this.getProductions()) {
            s = s + "<tr><td align=\"left\">" + p.toString() + "</td></tr>\\n";
        }
        return s + "</table>> ];";
    }

    class ProductionNotFoundException
    extends RuntimeException {
        private static final long serialVersionUID = 7951329358096393278L;

        public ProductionNotFoundException(Object o) {
            super(o.toString());
        }
    }
}

