/*
 * Decompiled with CFR 0.152.
 */
package dexter;

import dexter.grammar.Grammar;
import dexter.grammar.NonTerminalSym;
import dexter.grammar.Production;
import dexter.grammar.ProductionSet;
import dexter.grammar.Symbol;
import dexter.parser.ActionMap;
import dexter.parser.DynamicParserException;
import dexter.parser.Graph;
import dexter.parser.ITokenStream;
import dexter.parser.Item;
import dexter.parser.ProductionClashException;
import dexter.parser.ast.ASTNode;
import dexter.parser.ast.NodeStack;
import dexter.utils.StateSet;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class DynamicParser
implements Serializable {
    private static final long serialVersionUID = 7897303748611756437L;
    public Grammar grammar = new Grammar();
    public Graph graph = Graph.newGraph(this.grammar);
    public ActionMap actions = new ActionMap();
    int autoNTcount = 1;
    protected ASTNode parseTree;
    protected Production lastProduction = null;
    int debug = 1;
    ProductionSet pendingAdd = new ProductionSet(new Production[0]);
    ProductionSet pendingDel = new ProductionSet(new Production[0]);

    public void dprint(Object o) {
        if (this.debug < 1) {
            return;
        }
        System.out.println(o);
    }

    public void setStart(NonTerminalSym s) {
        Production oldStart = this.grammar.setStart(s);
        this.graph.setStart();
        this.graph.update(this.graph, this.grammar);
        if (oldStart != null) {
            this.removeStart(oldStart);
        }
    }

    public NonTerminalSym getStart() {
        return (NonTerminalSym)this.grammar.getStart().body.get(0);
    }

    public NonTerminalSym Or(Symbol ... symbols) {
        GeneratedNT newNT = new GeneratedNT(2);
        for (Symbol s : symbols) {
            this.add(newNT, s);
        }
        return newNT;
    }

    public NonTerminalSym Many(Symbol s) {
        GeneratedNT newNT = new GeneratedNT(0);
        this.add(newNT, s, newNT);
        this.add(newNT, s);
        return newNT;
    }

    public void addAll(ProductionSet collection) {
        for (Production p : collection.getProductions()) {
            this.add(p);
        }
    }

    public DynamicParser add(NonTerminalSym nt, Symbol ... body) {
        return this.add(new Production(nt, body));
    }

    public DynamicParser put(NonTerminalSym nt, Symbol[] body) {
        return this.add(new Production(nt, body));
    }

    public DynamicParser add(Production p) {
        if (this.grammar.contains(p)) {
            throw new ProductionClashException(p);
        }
        this.grammar.put(p);
        this.graph.update(p, this.grammar);
        this.lastProduction = p;
        return this;
    }

    public DynamicParser remove(NonTerminalSym nt, Symbol ... body) {
        return this.remove(new Production(nt, body));
    }

    public DynamicParser remove(Production p) {
        if (!this.grammar.contains(p)) {
            throw new RuntimeException("No such production: " + p);
        }
        this.grammar.remove(p);
        StateSet states = this.graph.stateFactory.getStateFromSymbol(p.nt);
        this.graph.remove(p, states, this.grammar);
        return this;
    }

    protected void removeStart(Production p) {
        StateSet s = new StateSet();
        this.graph.removeFromKernel(new Item(p, 0));
        s.add(this.graph);
        s.add(this.graph.goTo.get(p.body.get(0)));
        this.graph.remove(p, s, this.grammar);
    }

    @Deprecated
    public void setup() {
        System.out.println("setup() is deprecated\n");
        this.update();
    }

    public void update() {
        for (Production p : this.grammar.getProductions()) {
            this.grammar.nullables.update(p);
        }
        this.grammar.firstTable.update();
        this.graph.updateLookahead(this.grammar);
    }

    public ASTNode getLastParseTree() {
        return this.parseTree;
    }

    public boolean parse(ITokenStream tokens) {
        try {
            return this.parse(tokens, new NodeStack());
        }
        catch (DynamicParserException e) {
            System.err.println(e.getMessage());
            return false;
        }
    }

    protected boolean parse(ITokenStream tokens, NodeStack stack) {
        Graph currentState = this.graph;
        Item res = currentState.parse(tokens, stack);
        ASTNode root = stack.pop();
        this.parseTree = root.child(0);
        return root.getSymbol().equals(this.grammar.getStart().nt);
    }

    public void save(String path) throws IOException {
        FileOutputStream fos = new FileOutputStream(path);
        ObjectOutputStream oos = new ObjectOutputStream(fos);
        oos.writeObject(this);
        oos.close();
    }

    public static DynamicParser load(String path) throws IOException, ClassNotFoundException {
        FileInputStream fis = new FileInputStream(path);
        ObjectInputStream ois = new ObjectInputStream(fis);
        Object o = ois.readObject();
        ois.close();
        return (DynamicParser)o;
    }

    private class GeneratedNT
    implements NonTerminalSym {
        int id;
        static final int MANY = 0;
        static final int OR = 2;

        public GeneratedNT(int type) {
            this.id = 2 * DynamicParser.this.autoNTcount++ + (type == 0 ? 0 : 1);
        }

        public String toString() {
            return "g" + (this.id % 2 == 0 ? "MANY" : "OR") + this.id;
        }
    }
}

