/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.swing;

import de.hunsicker.jalopy.storage.Convention;
import de.hunsicker.jalopy.storage.Loggers;
import de.hunsicker.jalopy.swing.PreviewFrame;
import de.hunsicker.jalopy.swing.SettingsContainer;
import de.hunsicker.jalopy.swing.ValidationException;
import de.hunsicker.swing.ErrorDialog;
import de.hunsicker.swing.util.SwingHelper;
import de.hunsicker.util.ResourceBundleFactory;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.MessageFormat;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.PatternLayout;

public class SettingsDialog
extends JDialog {
    public static final String ARG_ECLIPSE = "-eclipse";
    private static final String BUNDLE_NAME = "de.hunsicker.jalopy.swing.Bundle";
    static PreviewFrame _previewFrame;
    private JButton _applyButton;
    private JButton _cancelButton;
    private JButton _okButton;
    SettingsContainer _preferencesContainer;

    protected SettingsDialog(Frame owner) {
        super(owner, ResourceBundleFactory.getBundle(BUNDLE_NAME).getString("TLE_JALOPY_SETTINGS"));
    }

    protected SettingsDialog(Dialog owner) {
        super(owner, ResourceBundleFactory.getBundle(BUNDLE_NAME).getString("TLE_JALOPY_SETTINGS"));
    }

    public static SettingsDialog create(Window owner, String title) {
        SettingsDialog dialog = SettingsDialog.create(owner);
        dialog.setTitle(title);
        return dialog;
    }

    public static SettingsDialog create(Window owner) {
        SettingsDialog dialog = null;
        if (owner instanceof Frame) {
            dialog = new SettingsDialog((Frame)owner);
        } else if (owner instanceof Dialog) {
            dialog = new SettingsDialog((Dialog)owner);
        }
        super.initialize();
        return dialog;
    }

    public int getHeight() {
        Container c = this.getParent();
        if (c instanceof SettingsFrame) {
            return c.getHeight();
        }
        return super.getHeight();
    }

    public void setLocation(int x, int y) {
        Container c = this.getParent();
        if (c instanceof SettingsFrame) {
            c.setLocation(x, y);
        } else {
            super.setLocation(x, y);
        }
    }

    public Point getLocation() {
        Container c = this.getParent();
        if (c instanceof SettingsFrame) {
            return c.getLocation();
        }
        return super.getLocation();
    }

    public int getWidth() {
        Container c = this.getParent();
        if (c instanceof SettingsFrame) {
            return c.getWidth();
        }
        return super.getWidth();
    }

    public int getX() {
        Container c = this.getParent();
        if (c instanceof SettingsFrame) {
            return c.getX();
        }
        return super.getX();
    }

    public int getY() {
        Container c = this.getParent();
        if (c instanceof SettingsFrame) {
            return c.getY();
        }
        return super.getY();
    }

    public static void main(String[] argv) {
        SettingsDialog dialog;
        if (argv.length == 0 || !argv[0].equals(ARG_ECLIPSE)) {
            Loggers.initialize(new ConsoleAppender((Layout)new PatternLayout("[%p] %m\n"), "System.out"));
        }
        int i = 0;
        while (i < argv.length) {
            if (argv[i].equals("-ui")) {
                SettingsDialog.initializeLookAndFeel(argv[i + 1]);
                ++i;
            }
            ++i;
        }
        final SettingsFrame frame = new SettingsFrame(ResourceBundleFactory.getBundle(BUNDLE_NAME).getString("TLE_JALOPY_SETTINGS"), argv);
        frame.dialog = dialog = SettingsDialog.create(frame);
        frame.getContentPane().add(dialog.getContentPane());
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent ev) {
                dialog._preferencesContainer.dispose();
                if (frame.isExitOnClose) {
                    System.exit(0);
                } else {
                    frame.dispose();
                    _previewFrame.dispose();
                }
            }

            public void windowOpened(WindowEvent ev) {
                dialog._preferencesContainer.displayPreview();
            }
        });
        frame.pack();
        Toolkit kit = dialog.getToolkit();
        frame.setLocation((kit.getScreenSize().width - frame.getWidth()) / 2, (kit.getScreenSize().height - frame.getHeight()) / 2);
        frame.setVisible(true);
    }

    public void show() {
        if (_previewFrame != null) {
            if (!_previewFrame.isVisible()) {
                this._preferencesContainer.displayPreview();
            } else {
                _previewFrame.toFront();
            }
        }
        super.show();
    }

    public void toFront() {
        Container c = this.getParent();
        if (c instanceof SettingsFrame) {
            ((SettingsFrame)c).toFront();
            c.requestFocus();
        } else {
            super.toFront();
        }
    }

    private static void initializeLookAndFeel(String clazz) {
        if (clazz != null) {
            try {
                UIManager.setLookAndFeel(clazz);
            }
            catch (Throwable ex) {
                Object[] args = new Object[]{clazz};
                System.err.println(MessageFormat.format(ResourceBundleFactory.getBundle(BUNDLE_NAME).getString("MSG_NOT_FIND_LAF"), args));
            }
        }
        if (UIManager.getLookAndFeel().getID().equals("Metal")) {
            int fontSize = 12;
            String fontName = "Tahoma";
            Font dialogPlain = new Font(fontName, 0, fontSize);
            Font serifPlain = new Font("Serif", 0, fontSize);
            Font sansSerifPlain = new Font("SansSerif", 0, fontSize);
            Font monospacedPlain = new Font("Monospaced", 0, fontSize);
            UIManager.put("Border.font", dialogPlain);
            UIManager.put("InternalFrameTitlePane.font", dialogPlain);
            UIManager.put("OptionPane.font", dialogPlain);
            UIManager.put("DesktopIcon.font", dialogPlain);
            UIManager.put("Button.font", dialogPlain);
            UIManager.put("ToggleButton.font", dialogPlain);
            UIManager.put("RadioButton.font", dialogPlain);
            UIManager.put("CheckBox.font", dialogPlain);
            UIManager.put("ColorChooser.font", dialogPlain);
            UIManager.put("ComboBox.font", dialogPlain);
            UIManager.put("Label.font", dialogPlain);
            UIManager.put("List.font", dialogPlain);
            UIManager.put("MenuBar.font", dialogPlain);
            UIManager.put("MenuItem.font", dialogPlain);
            UIManager.put("RadioButtonMenuItem.font", dialogPlain);
            UIManager.put("CheckBoxMenuItem.font", dialogPlain);
            UIManager.put("Menu.font", dialogPlain);
            UIManager.put("PopupMenu.font", dialogPlain);
            UIManager.put("OptionPane.font", dialogPlain);
            UIManager.put("Panel.font", dialogPlain);
            UIManager.put("ProgressBar.font", dialogPlain);
            UIManager.put("ScrollPane.font", dialogPlain);
            UIManager.put("Viewport.font", dialogPlain);
            UIManager.put("TabbedPane.font", dialogPlain);
            UIManager.put("Table.font", dialogPlain);
            UIManager.put("TableHeader.font", dialogPlain);
            UIManager.put("TextField.font", sansSerifPlain);
            UIManager.put("PasswordField.font", monospacedPlain);
            UIManager.put("TextArea.font", monospacedPlain);
            UIManager.put("TextPane.font", serifPlain);
            UIManager.put("EditorPane.font", serifPlain);
            UIManager.put("TitledBorder.font", dialogPlain);
            UIManager.put("ToolBar.font", dialogPlain);
            UIManager.put("ToolTip.font", sansSerifPlain);
            UIManager.put("Tree.font", dialogPlain);
        }
    }

    private void initialize() {
        this.setDefaultCloseOperation(2);
        this._okButton = SwingHelper.createButton(ResourceBundleFactory.getBundle(BUNDLE_NAME).getString("BTN_OK"), false);
        this._okButton.addActionListener(new OkActionHandler());
        Container container = this.getParent();
        if (container instanceof SettingsFrame) {
            ((JFrame)container).getRootPane().setDefaultButton(this._okButton);
            _previewFrame = PreviewFrame.create(this.getOwner());
            this._preferencesContainer = new SettingsContainer(_previewFrame);
        } else {
            this.getRootPane().setDefaultButton(this._okButton);
            _previewFrame = PreviewFrame.create(this.getOwner(), this);
            this._preferencesContainer = new SettingsContainer(_previewFrame);
        }
        GridBagLayout layout = new GridBagLayout();
        Container contentPane = this.getContentPane();
        contentPane.setLayout(layout);
        GridBagConstraints c = new GridBagConstraints();
        c.insets.top = 10;
        c.insets.left = 5;
        c.insets.right = 5;
        SwingHelper.setConstraints(c, 0, 0, 10, 10, 1.0, 1.0, 11, 1, c.insets, 0, 0);
        layout.setConstraints(this._preferencesContainer, c);
        contentPane.add(this._preferencesContainer);
        c.insets.bottom = 10;
        SwingHelper.setConstraints(c, 7, 11, 1, 1, 1.0, 0.0, 13, 0, c.insets, 0, 0);
        layout.setConstraints(this._okButton, c);
        contentPane.add(this._okButton);
        this._applyButton = SwingHelper.createButton(ResourceBundleFactory.getBundle(BUNDLE_NAME).getString("BTN_APPLY"), false);
        this._applyButton.addActionListener(new ApplyActionHandler());
        c.insets.left = 0;
        SwingHelper.setConstraints(c, 8, 11, 1, 1, 0.0, 0.0, 13, 0, c.insets, 0, 0);
        layout.setConstraints(this._applyButton, c);
        contentPane.add(this._applyButton);
        this._cancelButton = SwingHelper.createButton(ResourceBundleFactory.getBundle(BUNDLE_NAME).getString("BTN_CANCEL"), false);
        this._cancelButton.addActionListener(new CancelActionHandler());
        c.insets.right = 20;
        SwingHelper.setConstraints(c, 9, 11, 1, 1, 0.0, 0.0, 13, 0, c.insets, 0, 0);
        layout.setConstraints(this._cancelButton, c);
        contentPane.add(this._cancelButton);
        this.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent ev) {
                SettingsDialog.this._preferencesContainer.displayPreview();
            }

            public void windowClosing(WindowEvent ev) {
                SettingsDialog.this._preferencesContainer.dispose();
                _previewFrame.dispose();
            }
        });
    }

    boolean updateSettings() {
        try {
            this._preferencesContainer.updateSettings();
        }
        catch (ValidationException ex) {
            return false;
        }
        catch (Throwable ex) {
            Window owner = SwingUtilities.windowForComponent(this);
            ErrorDialog dialog = ErrorDialog.create(owner, ex);
            dialog.setVisible(true);
            dialog.dispose();
            return false;
        }
        try {
            Convention.getInstance().flush();
        }
        catch (Throwable ex) {
            ErrorDialog dialog = ErrorDialog.create(this, ex);
            dialog.setVisible(true);
            dialog.dispose();
            return false;
        }
        return true;
    }

    private final class OkActionHandler
    implements ActionListener {
        private OkActionHandler() {
        }

        public void actionPerformed(ActionEvent ev) {
            if (SettingsDialog.this.updateSettings()) {
                _previewFrame.dispose();
                SettingsDialog.this._preferencesContainer.dispose();
                SettingsDialog.this.dispose();
                Container c = SettingsDialog.this.getParent();
                if (c instanceof SettingsFrame) {
                    SettingsFrame f = (SettingsFrame)c;
                    if (f.isExitOnClose) {
                        System.exit(0);
                    } else {
                        f.dispose();
                    }
                }
            }
        }
    }

    private final class CancelActionHandler
    implements ActionListener {
        private CancelActionHandler() {
        }

        public void actionPerformed(ActionEvent ev) {
            _previewFrame.dispose();
            SettingsDialog.this._preferencesContainer.dispose();
            SettingsDialog.this.dispose();
            Container c = SettingsDialog.this.getParent();
            if (c instanceof SettingsFrame) {
                SettingsFrame f = (SettingsFrame)c;
                if (f.isExitOnClose) {
                    System.exit(0);
                } else {
                    f.dispose();
                }
            }
        }
    }

    private class ApplyActionHandler
    implements ActionListener {
        private ApplyActionHandler() {
        }

        public void actionPerformed(ActionEvent ev) {
            SettingsDialog.this.updateSettings();
        }
    }

    private static final class SettingsFrame
    extends JFrame {
        SettingsDialog dialog;
        boolean isExitOnClose = true;

        public SettingsFrame(String title, String[] argv) {
            super(title);
            this.setDefaultCloseOperation(2);
            this.setIconImage(new ImageIcon(this.getClass().getResource("resources/Preferences16.gif")).getImage());
            if (argv.length == 1 && argv[0].equals(SettingsDialog.ARG_ECLIPSE)) {
                this.isExitOnClose = false;
            }
        }
    }
}

