/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.language;

import de.hunsicker.io.DirectoryScanner;
import de.hunsicker.io.ExtensionFilter;
import de.hunsicker.io.IoHelper;
import de.hunsicker.jalopy.language.ClassRepositoryEntry;
import de.hunsicker.jalopy.storage.Convention;
import de.hunsicker.jalopy.storage.ConventionKeys;
import de.hunsicker.jalopy.storage.Loggers;
import de.hunsicker.util.ChainingRuntimeException;
import de.hunsicker.util.StringHelper;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.log4j.Level;

public class ClassRepository {
    static final String EXT_REPOSITORY = ".repository";
    private static final ClassRepositoryEntry.Info[] EMPTY_INFO_ARRAY = new ClassRepositoryEntry.Info[0];
    private static final String EMPTY_STRING = "".intern();
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final String EXT_CLASS = ".class";
    private static final String EXT_JAR = ".jar";
    private static final String EXT_ZIP = ".zip";
    private static final ClassRepository INSTANCE = new ClassRepository();
    private Convention _settings;
    private File _repositoryDirectory;
    private List _infos = new ArrayList();
    private String[] _content = EMPTY_STRING_ARRAY;
    static /* synthetic */ Class class$de$hunsicker$jalopy$language$ClassRepository;

    private ClassRepository() {
        this._settings = Convention.getInstance();
        File directory = this.getWorkingDir();
        if (!directory.exists()) {
            if (!directory.mkdirs()) {
                throw new RuntimeException("could not create the repository directory -- " + directory);
            }
        } else {
            this.preload();
        }
    }

    public static ClassRepository getInstance() {
        return INSTANCE;
    }

    public synchronized String[] getContent() {
        return this._content;
    }

    public synchronized boolean isEmpty() {
        return this._content.length == 0;
    }

    public synchronized ClassRepositoryEntry.Info[] getInfo() {
        ArrayList infos = new ArrayList(this._infos);
        return infos.toArray(EMPTY_INFO_ARRAY);
    }

    public int getSize() {
        return this._content.length;
    }

    public static ClassRepositoryEntry createEntry(ClassRepositoryEntry.Info info) throws IOException {
        File location = info.getLocation();
        if (!location.exists()) {
            throw new IllegalArgumentException(" no valid file or directory -- " + location);
        }
        HashSet types = new HashSet(20);
        if (location.isDirectory()) {
            DirectoryScanner scanner = new DirectoryScanner(location);
            scanner.addFilter(new ExtensionFilter(EXT_CLASS));
            scanner.run();
            int length = location.toString().length() + 1;
            File[] files = scanner.getFiles();
            boolean verify = true;
            int i = 0;
            int size = files.length;
            while (i < size) {
                String path = files[i].toString().substring(length);
                if (!ClassRepository.createEntryImpl(location, path = path.replace(File.separatorChar, '.'), types, verify)) {
                    throw new IOException("no package root directory -- " + location);
                }
                verify = false;
                ++i;
            }
        } else if (location.getName().endsWith(EXT_JAR) || location.getName().endsWith(EXT_ZIP)) {
            JarFile archive = new JarFile(location);
            Enumeration<JarEntry> enumerator = archive.entries();
            while (enumerator.hasMoreElements()) {
                JarEntry entry = enumerator.nextElement();
                String path = entry.getName();
                if (!path.endsWith(EXT_CLASS)) continue;
                path = path.replace('/', '.');
                ClassRepository.createEntryImpl(location, path, types, false);
            }
        } else {
            throw new IllegalArgumentException("no valid Java archive -- " + location);
        }
        return new ClassRepositoryEntry(info, types);
    }

    public synchronized ClassRepositoryEntry.Info get(File location) {
        int i = 0;
        int size = this._infos.size();
        while (i < size) {
            ClassRepositoryEntry.Info info = (ClassRepositoryEntry.Info)this._infos.get(i);
            if (info.getLocation().equals(location)) {
                return info;
            }
            ++i;
        }
        return null;
    }

    public synchronized void load(File location) throws IOException {
        ClassRepositoryEntry entry = this.loadEntry(location);
        if (entry == null) {
            return;
        }
        Set data = entry.getData();
        HashSet<String> temp = new HashSet<String>(this._content.length + data.size());
        temp.addAll(Arrays.asList(this._content));
        temp.addAll(data);
        this._content = temp.toArray(EMPTY_STRING_ARRAY);
        Arrays.sort(this._content);
        if (Loggers.IO.isDebugEnabled()) {
            Loggers.IO.debug("ClassRepository: Loaded " + data.size() + " classes from " + location);
        }
    }

    public synchronized void loadAll(List locations) throws IOException {
        if (locations == null) {
            return;
        }
        HashSet<String> data = new HashSet<String>(1000);
        Iterator i = locations.iterator();
        while (i.hasNext()) {
            File location = (File)i.next();
            ClassRepositoryEntry entry = this.loadEntry(location);
            if (entry == null) continue;
            data.addAll(entry.getData());
            if (!Loggers.IO.isDebugEnabled()) continue;
            Loggers.IO.debug("ClassRepository: Loaded " + data.size() + " classes from " + location);
        }
        if (!data.isEmpty()) {
            data.addAll(Arrays.asList(this._content));
            this._content = data.toArray(EMPTY_STRING_ARRAY);
            Arrays.sort(this._content);
        }
    }

    public synchronized ClassRepositoryEntry.Info loadInfo(File file) throws IOException {
        return (ClassRepositoryEntry.Info)IoHelper.deserialize(file);
    }

    public synchronized void unload(File location) throws IOException {
        ClassRepositoryEntry.Info template = new ClassRepositoryEntry.Info(location);
        if (!this._infos.contains(template)) {
            return;
        }
        ClassRepositoryEntry entry = ClassRepository.createEntry(template);
        Set data = entry.getData();
        HashSet<String> temp = new HashSet<String>(Arrays.asList(this._content));
        temp.removeAll(data);
        this._content = temp.toArray(EMPTY_STRING_ARRAY);
        Arrays.sort(this._content);
        ClassRepositoryEntry.Info info = (ClassRepositoryEntry.Info)this._infos.get(this._infos.indexOf(template));
        info.setLoaded(false);
        if (Loggers.IO.isDebugEnabled()) {
            Loggers.IO.debug("ClassRepository: Unloaded " + data.size() + " entries for " + location);
        }
    }

    public synchronized void unloadAll(List locations) throws IOException {
        HashSet data = new HashSet(1000);
        Iterator i = locations.iterator();
        while (i.hasNext()) {
            File location = (File)i.next();
            if (!location.exists()) continue;
            ClassRepositoryEntry entry = null;
            ClassRepositoryEntry.Info template = null;
            try {
                template = new ClassRepositoryEntry.Info(location);
                if (!this._infos.contains(template)) continue;
                entry = ClassRepository.createEntry(template);
                data.addAll(entry.getData());
            }
            catch (Exception ex) {
                ex.printStackTrace();
                continue;
            }
            ClassRepositoryEntry.Info info = (ClassRepositoryEntry.Info)this._infos.get(this._infos.indexOf(template));
            info.setLoaded(false);
            if (!Loggers.IO.isDebugEnabled()) continue;
            Loggers.IO.debug("ClassRepository: Unloaded " + entry.getData().size() + " entries for " + location);
        }
        if (!data.isEmpty()) {
            HashSet<String> temp = new HashSet<String>(Arrays.asList(this._content));
            temp.removeAll(data);
            this._content = temp.toArray(EMPTY_STRING_ARRAY);
            Arrays.sort(this._content);
        }
    }

    private File getWorkingDir() {
        if (this._repositoryDirectory == null) {
            this._repositoryDirectory = new File(this._settings.get(ConventionKeys.CLASS_REPOSITORY_DIRECTORY, Convention.getRepositoryDirectory().getAbsolutePath()));
        }
        return this._repositoryDirectory;
    }

    private static boolean createEntryImpl(File location, String path, Set types, boolean verify) {
        int pos = (path = path.substring(0, path.lastIndexOf(46))).lastIndexOf(36);
        if (pos > -1) {
            String className = path.substring(pos + 1);
            if (StringHelper.isNumber(className)) {
                return true;
            }
            path = path.replace('$', '.');
        } else if (verify) {
            try {
                URL[] url = new URL[]{location.toURL()};
                URLClassLoader loader = new URLClassLoader(url, (class$de$hunsicker$jalopy$language$ClassRepository == null ? (class$de$hunsicker$jalopy$language$ClassRepository = ClassRepository.class$("de.hunsicker.jalopy.language.ClassRepository")) : class$de$hunsicker$jalopy$language$ClassRepository).getClassLoader());
                loader.loadClass(path.replace(File.separatorChar, '.'));
            }
            catch (ClassNotFoundException ex) {
                Object[] args = new Object[]{path, location};
                Loggers.IO.l7dlog(Level.WARN, "REPOSITORY_NOT_PACKAGE_ROOT", args, null);
                return false;
            }
            catch (Throwable ex) {
                return false;
            }
        }
        String typeName = StringHelper.getClassName(path);
        if (typeName.length() == 1 && Character.isLowerCase(typeName.charAt(0))) {
            return true;
        }
        String packageName = StringHelper.getPackageName(path);
        if (!EMPTY_STRING.equals(packageName)) {
            types.add(packageName + '#');
        }
        types.add(path);
        return true;
    }

    private ClassRepositoryEntry loadEntry(File location) throws IOException {
        ClassRepositoryEntry.Info template;
        if (!location.exists()) {
            if (location.getName().endsWith(EXT_JAR) || location.getName().endsWith(EXT_ZIP)) {
                throw new IOException("File not found -- " + location);
            }
            if (!location.mkdirs()) {
                throw new IOException("Directory not found -- " + location);
            }
            if (Loggers.IO.isDebugEnabled()) {
                Loggers.IO.debug("ClassRepository: Created new directory: " + location);
            }
        }
        ClassRepositoryEntry.Info info = template = new ClassRepositoryEntry.Info(location);
        ClassRepositoryEntry entry = null;
        if (this._infos.contains(template)) {
            info = (ClassRepositoryEntry.Info)this._infos.get(this._infos.indexOf(template));
            if (Loggers.IO.isDebugEnabled()) {
                Loggers.IO.debug("ClassRepository: Already registered: " + info);
            }
            if (info.isLoaded()) {
                if (Loggers.IO.isDebugEnabled()) {
                    Loggers.IO.debug("ClassRepository: Alread loaded: " + info);
                }
                if (location.isDirectory()) {
                    if (Loggers.IO.isDebugEnabled()) {
                        Loggers.IO.debug("ClassRepository: Create new: " + info);
                        Loggers.IO.debug("ClassRepository: Save to disk: " + info);
                    }
                    entry = ClassRepository.createEntry(info);
                    this.saveToDisk(entry);
                } else {
                    if (location.lastModified() == info.getLocation().lastModified()) {
                        if (Loggers.IO.isDebugEnabled()) {
                            Loggers.IO.debug("ClassRepository: Up to date: " + info);
                        }
                        return entry;
                    }
                    if (Loggers.IO.isDebugEnabled()) {
                        Loggers.IO.debug("ClassRepository: Create new: " + info);
                        Loggers.IO.debug("ClassRepository: Save to disk: " + info);
                    }
                    entry = ClassRepository.createEntry(info);
                    this.saveToDisk(entry);
                }
            } else if (location.isDirectory()) {
                if (Loggers.IO.isDebugEnabled()) {
                    Loggers.IO.debug("ClassRepository: Create new: " + info);
                    Loggers.IO.debug("ClassRepository: Save to disk: " + info);
                }
                entry = ClassRepository.createEntry(info);
                this.saveToDisk(entry);
            } else {
                if (Loggers.IO.isDebugEnabled()) {
                    Loggers.IO.debug("ClassRepository: Load from disk: " + info);
                }
                entry = this.loadFromDisk(new File(this.getWorkingDir() + File.separator + info.getFilename()));
            }
        } else {
            this._infos.add(template);
            if (Loggers.IO.isDebugEnabled()) {
                Loggers.IO.debug("ClassRepository: Create new: " + info);
                Loggers.IO.debug("ClassRepository: Save to disk: " + info);
            }
            entry = ClassRepository.createEntry(template);
            this.saveToDisk(entry);
        }
        info = (ClassRepositoryEntry.Info)this._infos.get(this._infos.indexOf(template));
        info.setLoaded(true);
        return entry;
    }

    private ClassRepositoryEntry loadFromDisk(File file) throws IOException {
        ClassRepositoryEntry classRepositoryEntry;
        ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(new FileInputStream(file)));
        try {
            ClassRepositoryEntry entry = new ClassRepositoryEntry();
            entry.info = (ClassRepositoryEntry.Info)in.readObject();
            entry.data = (Set)in.readObject();
            in.close();
            file.setLastModified(System.currentTimeMillis());
            classRepositoryEntry = entry;
            Object var6_6 = null;
        }
        catch (ClassNotFoundException ex) {
            try {
                throw new ChainingRuntimeException(ex);
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                in.close();
                throw throwable;
            }
        }
        in.close();
        return classRepositoryEntry;
    }

    private void preload() {
        try {
            File[] files = this.getWorkingDir().listFiles(new ExtensionFilter(EXT_REPOSITORY));
            long now = System.currentTimeMillis();
            long delta = 1296000000L;
            int i = 0;
            while (i < files.length) {
                ClassRepositoryEntry.Info info = this.loadInfo(files[i]);
                this._infos.add(info);
                if (files[i].lastModified() + delta < now && !files[i].delete()) {
                    Object[] args = new Object[]{files[i]};
                    Loggers.IO.l7dlog(Level.INFO, "IMPORT_DELETE_UNUSED_ERR", args, null);
                }
                ++i;
            }
        }
        catch (Throwable ex) {
            this._infos.clear();
            Loggers.IO.warn("Error preloading the class repository, no import optimizaton available", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveToDisk(ClassRepositoryEntry entry) throws IOException {
        ClassRepositoryEntry.Info info = entry.getInfo();
        ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(this.getWorkingDir() + File.separator + entry.getInfo().getFilename())));
        try {
            out.writeObject(info);
            out.writeObject(entry.getData());
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            out.close();
            throw throwable;
        }
        out.close();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

