/*
 * Decompiled with CFR 0.152.
 */
package xtc.xform;

import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Item {
    Object object;
    Item parent;
    int index;
    List<Item> children;

    public Item() {
        this.object = null;
        this.parent = null;
        this.children = null;
        this.index = 0;
    }

    public Item(Object object, Item item, int n) {
        this.object = object;
        this.parent = item;
        this.index = n;
        this.children = null;
    }

    public Item(Object object, Item item, int n, List<Item> list) {
        this.object = object;
        this.parent = item;
        this.index = n;
        this.addChildren(list);
    }

    public Item(Item item) {
        this.object = item.object;
        this.parent = item.parent;
        this.index = item.index;
        this.addChildren(item.children);
    }

    public Object getObject() {
        return this.object;
    }

    public Item getParent() {
        return this.parent;
    }

    public int getIndex() {
        return this.index;
    }

    public List<Item> getChildren() {
        return this.children;
    }

    public boolean equals(Object object) {
        if (object instanceof Item) {
            Item item = (Item)object;
            return this.object == item.object && this.parent == item.parent && this.index == item.index;
        }
        return false;
    }

    public void addChild(Item item) {
        if (null == this.children) {
            this.children = new LinkedList<Item>();
        }
        item.parent = this;
        item.index = this.children.size();
        this.children.add(item);
    }

    public void addChild(Item item, int n) {
        if (null == this.children) {
            if (0 == n) {
                this.children = new LinkedList<Item>();
            } else {
                throw new RuntimeException("Error: Attempted to add first child at index greater than 0.");
            }
        }
        item.parent = this;
        item.index = n;
        this.children.add(n, item);
        for (int i = n + 1; i < this.children.size(); ++i) {
            this.children.get((int)i).index = i;
        }
    }

    public void addChildren(List<Item> list) {
        if (null == list) {
            return;
        }
        if (null == this.children) {
            this.children = new LinkedList<Item>();
        }
        int n = this.children.size();
        for (Item item : list) {
            item.index = n++;
            item.parent = this;
            this.children.add(item);
        }
    }

    public void addChildren(List<Item> list, int n) {
        if (null == this.children) {
            if (0 == n) {
                this.children = new LinkedList<Item>();
            } else {
                throw new RuntimeException("Error: Attempted to add first children at an index greater than 0.");
            }
        }
        int n2 = n;
        for (Item item : list) {
            item.parent = this;
            item.index = n++;
        }
        this.children.addAll(n2, list);
        while (n < this.children.size()) {
            this.children.get((int)n).index = n;
            ++n;
        }
    }

    public void removeChild(int n) {
        this.children.remove(n);
        while (n < this.children.size()) {
            this.children.get((int)n).index = n;
            ++n;
        }
    }

    public void replaceChild(int n, Item item) {
        item.parent = this;
        item.index = n;
        this.children.set(n, item);
    }

    public void replaceChild(int n, List<Item> list) {
        this.removeChild(n);
        this.addChildren(list, n);
    }

    public List<Object> addToList(List<Object> list) {
        if (!list.contains(this)) {
            list.add(this);
        }
        return list;
    }

    public String toString() {
        if (null == this.object) {
            return "null";
        }
        if (this.object instanceof String) {
            return (String)this.object;
        }
        return this.object.toString();
    }
}

