/*
 * Decompiled with CFR 0.152.
 */
package xtc.util;

import java.util.Arrays;
import junit.framework.TestCase;
import xtc.util.Pair;
import xtc.util.Utilities;

public class UtilitiesTest
extends TestCase {
    public void testIsQualified() {
        UtilitiesTest.assertFalse((boolean)Utilities.isQualified(""));
        UtilitiesTest.assertFalse((boolean)Utilities.isQualified("a"));
        UtilitiesTest.assertFalse((boolean)Utilities.isQualified("aa"));
        UtilitiesTest.assertFalse((boolean)Utilities.isQualified("aaa"));
        UtilitiesTest.assertFalse((boolean)Utilities.isQualified("a()"));
        UtilitiesTest.assertFalse((boolean)Utilities.isQualified("a(a)"));
        UtilitiesTest.assertFalse((boolean)Utilities.isQualified("a(.)"));
        UtilitiesTest.assertFalse((boolean)Utilities.isQualified("a(..)"));
        UtilitiesTest.assertFalse((boolean)Utilities.isQualified("a(...)"));
        UtilitiesTest.assertFalse((boolean)Utilities.isQualified("a(...)()"));
        UtilitiesTest.assertFalse((boolean)Utilities.isQualified("a(...)(.)"));
        UtilitiesTest.assertFalse((boolean)Utilities.isQualified("a(...)(..)"));
        UtilitiesTest.assertFalse((boolean)Utilities.isQualified("a(...)(...)"));
        UtilitiesTest.assertTrue((boolean)Utilities.isQualified("."));
        UtilitiesTest.assertTrue((boolean)Utilities.isQualified("a."));
        UtilitiesTest.assertTrue((boolean)Utilities.isQualified(".b"));
        UtilitiesTest.assertTrue((boolean)Utilities.isQualified("a.b"));
        UtilitiesTest.assertTrue((boolean)Utilities.isQualified("aa.bb"));
        UtilitiesTest.assertTrue((boolean)Utilities.isQualified("aaa.bbb"));
        UtilitiesTest.assertTrue((boolean)Utilities.isQualified("().()"));
        UtilitiesTest.assertTrue((boolean)Utilities.isQualified("()().()()"));
        UtilitiesTest.assertTrue((boolean)Utilities.isQualified("()()().()()()"));
        UtilitiesTest.assertTrue((boolean)Utilities.isQualified("aaa.bbb."));
        UtilitiesTest.assertTrue((boolean)Utilities.isQualified(".aaa.bbb"));
    }

    public void testGetQualifier() {
        UtilitiesTest.assertNull((Object)Utilities.getQualifier(""));
        UtilitiesTest.assertNull((Object)Utilities.getQualifier("a"));
        UtilitiesTest.assertNull((Object)Utilities.getQualifier("aa"));
        UtilitiesTest.assertNull((Object)Utilities.getQualifier("aaa"));
        UtilitiesTest.assertEquals((String)"", (String)Utilities.getQualifier("."));
        UtilitiesTest.assertEquals((String)"", (String)Utilities.getQualifier(".a"));
        UtilitiesTest.assertEquals((String)"", (String)Utilities.getQualifier(".aa"));
        UtilitiesTest.assertEquals((String)"", (String)Utilities.getQualifier(".aaa"));
        UtilitiesTest.assertEquals((String)".", (String)Utilities.getQualifier("..a"));
        UtilitiesTest.assertEquals((String)"..", (String)Utilities.getQualifier("...aa"));
        UtilitiesTest.assertEquals((String)"...", (String)Utilities.getQualifier("....aa"));
        UtilitiesTest.assertEquals((String)"..(.)", (String)Utilities.getQualifier("..(.).aa"));
        UtilitiesTest.assertEquals((String)"..", (String)Utilities.getQualifier("...(.)"));
        UtilitiesTest.assertEquals((String)"..", (String)Utilities.getQualifier("...(.)a"));
        UtilitiesTest.assertEquals((String)"..", (String)Utilities.getQualifier("...(.)aa"));
        UtilitiesTest.assertEquals((String)"..", (String)Utilities.getQualifier("...(.)(.)"));
        UtilitiesTest.assertEquals((String)"..", (String)Utilities.getQualifier("...(.)(.)a"));
    }

    public void testGetName() {
        UtilitiesTest.assertEquals((String)"", (String)Utilities.getName(""));
        UtilitiesTest.assertEquals((String)"a", (String)Utilities.getName("a"));
        UtilitiesTest.assertEquals((String)"aa", (String)Utilities.getName("aa"));
        UtilitiesTest.assertEquals((String)"aaa", (String)Utilities.getName("aaa"));
        UtilitiesTest.assertEquals((String)"", (String)Utilities.getName("."));
        UtilitiesTest.assertEquals((String)"", (String)Utilities.getName("a."));
        UtilitiesTest.assertEquals((String)"", (String)Utilities.getName("aa."));
        UtilitiesTest.assertEquals((String)"", (String)Utilities.getName("aaa."));
        UtilitiesTest.assertEquals((String)"a", (String)Utilities.getName(".a"));
        UtilitiesTest.assertEquals((String)"aa", (String)Utilities.getName(".aa"));
        UtilitiesTest.assertEquals((String)"aaa", (String)Utilities.getName(".aaa"));
        UtilitiesTest.assertEquals((String)"aaa", (String)Utilities.getName("..aaa"));
        UtilitiesTest.assertEquals((String)"aaa", (String)Utilities.getName("...aaa"));
        UtilitiesTest.assertEquals((String)"(.)", (String)Utilities.getName("..(.)"));
        UtilitiesTest.assertEquals((String)"(.)a", (String)Utilities.getName("..(.)a"));
        UtilitiesTest.assertEquals((String)"(.)aa", (String)Utilities.getName("..(.)aa"));
        UtilitiesTest.assertEquals((String)"(.)aaa", (String)Utilities.getName("..(.)aaa"));
        UtilitiesTest.assertEquals((String)"(..)aaa", (String)Utilities.getName(".(..)aaa"));
        UtilitiesTest.assertEquals((String)"()", (String)Utilities.getName("..()"));
        UtilitiesTest.assertEquals((String)"()()", (String)Utilities.getName("..()()"));
        UtilitiesTest.assertEquals((String)"(.)(.)", (String)Utilities.getName("..(.)(.)"));
    }

    public void testToIdentifier() {
        UtilitiesTest.assertEquals((String)"", (String)Utilities.toIdentifier(""));
        UtilitiesTest.assertEquals((String)"$", (String)Utilities.toIdentifier("."));
        UtilitiesTest.assertEquals((String)"$$", (String)Utilities.toIdentifier(".."));
        UtilitiesTest.assertEquals((String)"$$$", (String)Utilities.toIdentifier("..."));
        UtilitiesTest.assertEquals((String)"$a", (String)Utilities.toIdentifier(".a"));
        UtilitiesTest.assertEquals((String)"$$a", (String)Utilities.toIdentifier("..a"));
        UtilitiesTest.assertEquals((String)"$$$a", (String)Utilities.toIdentifier("...a"));
        UtilitiesTest.assertEquals((String)"a$", (String)Utilities.toIdentifier("a."));
        UtilitiesTest.assertEquals((String)"a$$", (String)Utilities.toIdentifier("a.."));
        UtilitiesTest.assertEquals((String)"a$$$", (String)Utilities.toIdentifier("a..."));
        UtilitiesTest.assertEquals((String)"a$a", (String)Utilities.toIdentifier("a.a"));
        UtilitiesTest.assertEquals((String)"a$$a", (String)Utilities.toIdentifier("a..a"));
        UtilitiesTest.assertEquals((String)"a$$$a", (String)Utilities.toIdentifier("a...a"));
        UtilitiesTest.assertEquals((String)"$aa", (String)Utilities.toIdentifier(".aa"));
        UtilitiesTest.assertEquals((String)"aa$", (String)Utilities.toIdentifier("aa."));
        UtilitiesTest.assertEquals((String)"aa$aa", (String)Utilities.toIdentifier("aa.aa"));
        UtilitiesTest.assertEquals((String)"$aaa", (String)Utilities.toIdentifier(".aaa"));
        UtilitiesTest.assertEquals((String)"aaa$", (String)Utilities.toIdentifier("aaa."));
        UtilitiesTest.assertEquals((String)"aaa$aaa", (String)Utilities.toIdentifier("aaa.aaa"));
        UtilitiesTest.assertEquals((String)"()", (String)Utilities.toIdentifier("()"));
        UtilitiesTest.assertEquals((String)"(.)", (String)Utilities.toIdentifier("(.)"));
        UtilitiesTest.assertEquals((String)"(.)(.)", (String)Utilities.toIdentifier("(.)(.)"));
        UtilitiesTest.assertEquals((String)"$(.)(.)", (String)Utilities.toIdentifier(".(.)(.)"));
        UtilitiesTest.assertEquals((String)"(.)$(.)", (String)Utilities.toIdentifier("(.).(.)"));
        UtilitiesTest.assertEquals((String)"(.)(.)$", (String)Utilities.toIdentifier("(.)(.)."));
    }

    public void testToComponents() {
        UtilitiesTest.assertTrue((boolean)Arrays.equals(new String[]{""}, Utilities.toComponents("")));
        UtilitiesTest.assertTrue((boolean)Arrays.equals(new String[]{"a"}, Utilities.toComponents("a")));
        UtilitiesTest.assertTrue((boolean)Arrays.equals(new String[]{"aa"}, Utilities.toComponents("aa")));
        UtilitiesTest.assertTrue((boolean)Arrays.equals(new String[]{"aaa"}, Utilities.toComponents("aaa")));
        UtilitiesTest.assertTrue((boolean)Arrays.equals(new String[]{"()"}, Utilities.toComponents("()")));
        UtilitiesTest.assertTrue((boolean)Arrays.equals(new String[]{"(.)"}, Utilities.toComponents("(.)")));
        UtilitiesTest.assertTrue((boolean)Arrays.equals(new String[]{"(.)(.)"}, Utilities.toComponents("(.)(.)")));
        UtilitiesTest.assertTrue((boolean)Arrays.equals(new String[]{"", ""}, Utilities.toComponents(".")));
        UtilitiesTest.assertTrue((boolean)Arrays.equals(new String[]{"", "", ""}, Utilities.toComponents("..")));
        UtilitiesTest.assertTrue((boolean)Arrays.equals(new String[]{"", "", "", ""}, Utilities.toComponents("...")));
        UtilitiesTest.assertTrue((boolean)Arrays.equals(new String[]{"a", ""}, Utilities.toComponents("a.")));
        UtilitiesTest.assertTrue((boolean)Arrays.equals(new String[]{"", "a"}, Utilities.toComponents(".a")));
        UtilitiesTest.assertTrue((boolean)Arrays.equals(new String[]{"a", "a"}, Utilities.toComponents("a.a")));
        UtilitiesTest.assertTrue((boolean)Arrays.equals(new String[]{"a", "a", "a"}, Utilities.toComponents("a.a.a")));
        UtilitiesTest.assertTrue((boolean)Arrays.equals(new String[]{"a", "a", "a", "a"}, Utilities.toComponents("a.a.a.a")));
    }

    public void testAppendix() {
        Pair<Object> pair = Pair.empty();
        pair = new Pair<Integer>(2, pair);
        pair = new Pair<Integer>(1, pair);
        Pair<Object> pair2 = Pair.empty();
        pair2 = new Pair<Integer>(4, pair2);
        pair2 = new Pair<Integer>(3, pair2);
        Pair<Object> pair3 = Pair.empty();
        pair3 = new Pair<Integer>(4, pair3);
        pair3 = new Pair<Integer>(3, pair3);
        pair3 = new Pair<Integer>(2, pair3);
        pair3 = new Pair<Integer>(1, pair3);
        Pair<Object> pair4 = Pair.empty();
        pair4 = new Pair<Integer>(2, pair4);
        pair4 = new Pair<Integer>(1, pair4);
        Pair<Object> pair5 = pair.append(pair2);
        UtilitiesTest.assertTrue((pair5 != pair ? 1 : 0) != 0);
        UtilitiesTest.assertTrue((boolean)pair5.equals(pair3));
        UtilitiesTest.assertTrue((boolean)pair.equals(pair4));
        pair.setLastTail(pair2);
        UtilitiesTest.assertTrue((boolean)pair.equals(pair3));
    }
}

