/*
 * Decompiled with CFR 0.152.
 */
package xtc.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Utilities {
    private static final int BUFFER_SIZE = 4096;
    private static char[] charBuffer = null;
    public static final Pattern WHITE_SPACE = Pattern.compile("\\s+");
    public static final Pattern SPACE_NEWLINE_SPACE = Pattern.compile("[ \t\f]*(?:\r\n|\r|\n)[ \t\f]*");
    public static final Pattern COMMENT_NEWLINE = Pattern.compile("[ \t\f]*(?:\r\n|\r|\n)[ \t\f]*\\**[ \t\f]*");
    public static final int ESCAPE_BELL_VT = 1;
    public static final int ESCAPE_DOUBLE = 2;
    public static final int ESCAPE_REGEX = 4;
    public static final int ESCAPE_UNICODE = 8;
    public static final int ESCAPE_HTML = 16;
    public static final int C_ESCAPES = 9;
    public static final int JAVA_ESCAPES = 8;
    public static final int JAVA_HTML_ESCAPES = 24;
    public static final int FULL_ESCAPES = 12;
    public static final int FULL_HTML_ESCAPES = 28;

    private Utilities() {
    }

    public static boolean isQualified(String string) {
        int n = string.length();
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (bl) {
                if (')' != c) continue;
                bl = false;
                continue;
            }
            if ('.' == c) {
                return true;
            }
            if ('(' != c) continue;
            bl = true;
        }
        return false;
    }

    public static String getQualifier(String string) {
        boolean bl = false;
        for (int i = string.length() - 1; i >= 0; --i) {
            char c = string.charAt(i);
            if (bl) {
                if ('(' != c) continue;
                bl = false;
                continue;
            }
            if ('.' == c) {
                return string.substring(0, i);
            }
            if (')' != c) continue;
            bl = true;
        }
        return null;
    }

    public static String getName(String string) {
        boolean bl = false;
        for (int i = string.length() - 1; i >= 0; --i) {
            char c = string.charAt(i);
            if (bl) {
                if ('(' != c) continue;
                bl = false;
                continue;
            }
            if ('.' == c) {
                return string.substring(i + 1);
            }
            if (')' != c) continue;
            bl = true;
        }
        return string;
    }

    public static String unqualify(String string) {
        return Utilities.isQualified(string) ? Utilities.getName(string) : string;
    }

    public static String qualify(String string, String string2) {
        return null == string ? string2 : string + '.' + string2;
    }

    public static String[] toComponents(String string) {
        int n;
        int n2 = string.length();
        int n3 = 1;
        boolean bl = false;
        for (int i = 0; i < n2; ++i) {
            n = string.charAt(i);
            if (bl) {
                if (41 != n) continue;
                bl = false;
                continue;
            }
            if (46 == n) {
                ++n3;
            }
            if (40 != n) continue;
            bl = true;
        }
        if (1 == n3) {
            return new String[]{string};
        }
        String[] stringArray = new String[n3];
        n = -1;
        n3 = 0;
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            if (bl) {
                if (')' != c) continue;
                bl = false;
                continue;
            }
            if ('.' == c) {
                stringArray[n3] = string.substring(n + 1, i);
                n = i;
                ++n3;
                continue;
            }
            if ('(' != c) continue;
            bl = true;
        }
        stringArray[n3] = string.substring(n + 1, n2);
        return stringArray;
    }

    private static String requalify(String string, char c) {
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder(n);
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            char c2 = string.charAt(i);
            if (bl) {
                stringBuilder.append(c2);
                if (')' != c2) continue;
                bl = false;
                continue;
            }
            if ('.' == c2) {
                stringBuilder.append(c);
                continue;
            }
            stringBuilder.append(c2);
            if ('(' != c2) continue;
            bl = true;
        }
        return stringBuilder.toString();
    }

    public static String toIdentifier(String string) {
        return Utilities.requalify(string, '$');
    }

    public static String toPath(String string) {
        return Utilities.requalify(string, File.separatorChar);
    }

    public static String toPath(String string, String string2) {
        return Utilities.toPath(string) + '.' + string2;
    }

    public static File locate(List<File> list, String string) throws FileNotFoundException {
        for (File file : list) {
            File file2 = new File(file, string);
            if (!file2.exists() || !file2.isFile()) continue;
            return file2;
        }
        throw new FileNotFoundException(string + " not found");
    }

    public static void pump(Reader reader, Writer writer) throws IOException {
        if (null == charBuffer) {
            charBuffer = new char[4096];
        }
        int n = reader.read(charBuffer);
        while (-1 != n) {
            writer.write(charBuffer, 0, n);
            n = reader.read(charBuffer);
        }
    }

    public static String withoutSpace(String string) {
        return WHITE_SPACE.matcher(string).replaceAll("");
    }

    public static boolean useBellVTEscapes(int n) {
        return 0 != (1 & n);
    }

    public static boolean useDoubleEscapes(int n) {
        return 0 != (2 & n);
    }

    public static boolean useRegexEscapes(int n) {
        return 0 != (4 & n);
    }

    public static boolean useUnicodeEscapes(int n) {
        return 0 != (8 & n);
    }

    public static boolean useHTMLEscapes(int n) {
        return 0 != (0x10 & n);
    }

    public static void escape(char c, Appendable appendable, int n) throws IOException {
        switch (c) {
            case '\u0007': {
                if (!Utilities.useBellVTEscapes(n)) break;
                if (Utilities.useDoubleEscapes(n)) {
                    appendable.append("\\\\a");
                    break;
                }
                appendable.append("\\a");
                break;
            }
            case '\b': {
                if (Utilities.useDoubleEscapes(n)) {
                    appendable.append("\\\\b");
                } else {
                    appendable.append("\\b");
                }
                return;
            }
            case '\t': {
                if (Utilities.useDoubleEscapes(n)) {
                    appendable.append("\\\\t");
                } else {
                    appendable.append("\\t");
                }
                return;
            }
            case '\n': {
                if (Utilities.useDoubleEscapes(n)) {
                    appendable.append("\\\\n");
                } else {
                    appendable.append("\\n");
                }
                return;
            }
            case '\u000b': {
                if (!Utilities.useBellVTEscapes(n)) break;
                if (Utilities.useDoubleEscapes(n)) {
                    appendable.append("\\\\v");
                    break;
                }
                appendable.append("\\v");
                break;
            }
            case '\f': {
                if (Utilities.useDoubleEscapes(n)) {
                    appendable.append("\\\\f");
                } else {
                    appendable.append("\\f");
                }
                return;
            }
            case '\r': {
                if (Utilities.useDoubleEscapes(n)) {
                    appendable.append("\\\\r");
                } else {
                    appendable.append("\\r");
                }
                return;
            }
            case '\"': {
                if (Utilities.useDoubleEscapes(n)) {
                    appendable.append("\\\\\\\"");
                } else {
                    appendable.append("\\\"");
                }
                return;
            }
            case '\'': {
                if (Utilities.useDoubleEscapes(n)) {
                    appendable.append("\\\\\\'");
                } else {
                    appendable.append("\\'");
                }
                return;
            }
            case '-': {
                if (Utilities.useRegexEscapes(n)) {
                    if (Utilities.useDoubleEscapes(n)) {
                        appendable.append("\\\\-");
                    } else {
                        appendable.append("\\-");
                    }
                } else {
                    appendable.append('-');
                }
                return;
            }
            case '<': {
                if (Utilities.useHTMLEscapes(n)) {
                    appendable.append("&lt;");
                } else {
                    appendable.append('<');
                }
                return;
            }
            case '>': {
                if (Utilities.useHTMLEscapes(n)) {
                    appendable.append("&gt;");
                } else {
                    appendable.append('>');
                }
                return;
            }
            case '[': {
                if (Utilities.useRegexEscapes(n)) {
                    if (Utilities.useDoubleEscapes(n)) {
                        appendable.append("\\\\[");
                    } else {
                        appendable.append("\\[");
                    }
                } else {
                    appendable.append('[');
                }
                return;
            }
            case '\\': {
                if (Utilities.useDoubleEscapes(n)) {
                    appendable.append("\\\\\\\\");
                } else {
                    appendable.append("\\\\");
                }
                return;
            }
            case ']': {
                if (Utilities.useRegexEscapes(n)) {
                    if (Utilities.useDoubleEscapes(n)) {
                        appendable.append("\\\\]");
                    } else {
                        appendable.append("\\]");
                    }
                } else {
                    appendable.append(']');
                }
                return;
            }
        }
        if (Utilities.useUnicodeEscapes(n) && (' ' > c || '~' < c)) {
            String string;
            String string2 = Integer.toHexString(c);
            switch (string2.length()) {
                case 1: {
                    string = "000";
                    break;
                }
                case 2: {
                    string = "00";
                    break;
                }
                case 3: {
                    string = "0";
                    break;
                }
                default: {
                    string = "";
                }
            }
            if (Utilities.useDoubleEscapes(n)) {
                appendable.append("\\\\");
            } else {
                appendable.append("\\");
            }
            appendable.append('u');
            appendable.append(string);
            appendable.append(string2);
        } else {
            appendable.append(c);
        }
    }

    public static void escape(String string, Appendable appendable, int n) throws IOException {
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            Utilities.escape(string.charAt(i), appendable, n);
        }
    }

    public static String escape(char c, int n) {
        StringBuilder stringBuilder;
        block2: {
            stringBuilder = new StringBuilder(1);
            try {
                Utilities.escape(c, (Appendable)stringBuilder, n);
            }
            catch (IOException iOException) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        return stringBuilder.toString();
    }

    public static String escape(String string, int n) {
        StringBuilder stringBuilder;
        block2: {
            stringBuilder = new StringBuilder(string.length());
            try {
                Utilities.escape(string, (Appendable)stringBuilder, n);
            }
            catch (IOException iOException) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        return stringBuilder.toString();
    }

    public static String unescape(String string) {
        if (-1 == string.indexOf(92)) {
            return string;
        }
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder(n);
        block20: for (int i = 0; i < n; ++i) {
            int n2 = string.charAt(i);
            if (92 != n2) {
                stringBuilder.append((char)n2);
                continue;
            }
            if (++i >= n) {
                throw new IllegalArgumentException("incomplete escape sequence");
            }
            n2 = string.charAt(i);
            switch (n2) {
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: {
                    int n3 = n2;
                    if (i + 1 < n && 48 <= (n2 = string.charAt(i + 1)) && n2 <= 55) {
                        n3 = n3 * 8 + n2;
                        if (++i + 1 < n && 48 <= (n2 = (int)string.charAt(i + 1)) && n2 <= 55) {
                            n3 = n3 * 8 + n2;
                            ++i;
                        }
                    }
                    stringBuilder.append((char)n3);
                    continue block20;
                }
                case 34: {
                    stringBuilder.append('\"');
                    continue block20;
                }
                case 39: {
                    stringBuilder.append('\'');
                    continue block20;
                }
                case 45: {
                    stringBuilder.append('-');
                    continue block20;
                }
                case 63: {
                    stringBuilder.append('?');
                    continue block20;
                }
                case 91: {
                    stringBuilder.append('[');
                    continue block20;
                }
                case 92: {
                    stringBuilder.append('\\');
                    continue block20;
                }
                case 93: {
                    stringBuilder.append(']');
                    continue block20;
                }
                case 97: {
                    stringBuilder.append('\u0007');
                    continue block20;
                }
                case 98: {
                    stringBuilder.append('\b');
                    continue block20;
                }
                case 102: {
                    stringBuilder.append('\f');
                    continue block20;
                }
                case 110: {
                    stringBuilder.append('\n');
                    continue block20;
                }
                case 114: {
                    stringBuilder.append('\r');
                    continue block20;
                }
                case 116: {
                    stringBuilder.append('\t');
                    continue block20;
                }
                case 117: {
                    int n3;
                    if ((i += 4) >= n) {
                        throw new IllegalArgumentException("incomplete universal character name " + string.substring(i - 3));
                    }
                    try {
                        n3 = Integer.parseInt(string.substring(i - 3, i + 1), 16);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IllegalArgumentException("malformed universal character name " + string.substring(i - 3, i + 1));
                    }
                    stringBuilder.append((char)n3);
                    continue block20;
                }
                case 118: {
                    stringBuilder.append('\u000b');
                    continue block20;
                }
                default: {
                    throw new IllegalArgumentException("illegal escaped character '\\" + (char)n2 + "'");
                }
            }
        }
        return stringBuilder.toString();
    }

    public static String format(List<?> list) {
        int n = list.size();
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<?> iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = iterator.next().toString();
            if (1 < n && !iterator.hasNext()) {
                stringBuilder.append("and ");
            }
            stringBuilder.append(string);
            if (2 == n && iterator.hasNext()) {
                stringBuilder.append(' ');
                continue;
            }
            if (!iterator.hasNext()) continue;
            stringBuilder.append(", ");
        }
        return stringBuilder.toString();
    }

    public static String split(String string, char c) {
        int n;
        int n2 = string.indexOf(36);
        if (-1 != n2) {
            string = string.substring(0, n2);
        }
        int n3 = string.length();
        boolean bl = false;
        int n4 = 0;
        for (n = 0; n < n3; ++n) {
            if (!Character.isUpperCase(string.charAt(n))) continue;
            if (0 == n) {
                bl = true;
            }
            ++n4;
        }
        if (0 == n4 || n3 == n4) {
            return string;
        }
        n = bl ? n3 + n4 - 1 : n3 + n4;
        StringBuilder stringBuilder = new StringBuilder(n);
        for (int i = 0; i < n3; ++i) {
            char c2 = string.charAt(i);
            if (Character.isUpperCase(c2)) {
                if (0 != i) {
                    stringBuilder.append(c);
                }
                stringBuilder.append(Character.toLowerCase(c2));
                continue;
            }
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    public static String toArticle(String string) {
        if (string.startsWith("a") || string.startsWith("e") || string.startsWith("i") || string.startsWith("o") || string.startsWith("u")) {
            return "an";
        }
        return "a";
    }
}

