/*
 * Decompiled with CFR 0.152.
 */
package xtc.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import xtc.parser.PParser;
import xtc.parser.ParseError;
import xtc.parser.Result;
import xtc.parser.SemanticValue;
import xtc.tree.Attribute;
import xtc.tree.Node;
import xtc.tree.Printer;
import xtc.util.Option;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Runtime {
    public static final String INPUT_DIRECTORY = "inputDirectory";
    public static final String OUTPUT_DIRECTORY = "outputDirectory";
    public static final String INPUT_ENCODING = "inputEncoding";
    public static final String OUTPUT_ENCODING = "outputEncoding";
    protected Printer console = new Printer(new BufferedWriter(new OutputStreamWriter(System.out)));
    protected Printer errConsole = new Printer(new BufferedWriter(new OutputStreamWriter(System.err)));
    protected final List<Option> optionList = new ArrayList<Option>();
    protected final Map<String, Option> externalMap = new HashMap<String, Option>();
    protected final Map<String, Option> internalMap = new HashMap<String, Option>();
    protected final Map<String, Object> options = new HashMap<String, Object>();
    protected int errors = 0;
    protected int warnings = 0;

    public Printer console() {
        return this.console;
    }

    public void setConsole(Printer printer) {
        this.console = printer;
    }

    public Printer errConsole() {
        return this.errConsole;
    }

    public void setErrConsole(Printer printer) {
        this.errConsole = printer;
    }

    public long freeMemory() {
        return java.lang.Runtime.getRuntime().freeMemory();
    }

    protected void check(String string, String string2) {
        if (this.externalMap.containsKey(string)) {
            throw new IllegalArgumentException("Option with external name " + string + " already exists");
        }
        if (this.internalMap.containsKey(string2)) {
            throw new IllegalArgumentException("Option with internal name " + string2 + " already exists");
        }
    }

    protected void add(Option option) {
        this.optionList.add(option);
        this.externalMap.put(option.external, option);
        this.internalMap.put(option.internal, option);
    }

    public Runtime bool(String string, String string2, boolean bl, String string3) {
        this.check(string, string2);
        this.add(new Option(Option.Kind.BOOLEAN, string, string2, bl, false, string3));
        return this;
    }

    public Runtime word(String string, String string2, boolean bl, String string3) {
        this.check(string, string2);
        this.add(new Option(Option.Kind.WORD, string, string2, null, bl, string3));
        return this;
    }

    public Runtime number(String string, String string2, int n, String string3) {
        this.check(string, string2);
        this.add(new Option(Option.Kind.INTEGER, string, string2, new Integer(n), false, string3));
        return this;
    }

    public Runtime file(String string, String string2, boolean bl, String string3) {
        this.check(string, string2);
        this.add(new Option(Option.Kind.FILE, string, string2, null, bl, string3));
        return this;
    }

    public Runtime dir(String string, String string2, boolean bl, String string3) {
        this.check(string, string2);
        this.add(new Option(Option.Kind.DIRECTORY, string, string2, new File(System.getProperty("user.dir")), bl, string3));
        return this;
    }

    public Runtime att(String string, String string2, boolean bl, String string3) {
        this.check(string, string2);
        this.add(new Option(Option.Kind.ATTRIBUTE, string, string2, null, bl, string3));
        return this;
    }

    public void printOptions() {
        int n = 0;
        block13: for (Option option : this.optionList) {
            switch (option.kind) {
                case BOOLEAN: {
                    n = Math.max(n, option.external.length() + 5);
                    continue block13;
                }
                case WORD: 
                case FILE: {
                    n = Math.max(n, option.external.length() + 5 + 7);
                    continue block13;
                }
                case INTEGER: 
                case DIRECTORY: 
                case ATTRIBUTE: {
                    n = Math.max(n, option.external.length() + 5 + 6);
                    continue block13;
                }
            }
            assert (false) : "Invalid option " + option;
        }
        for (Option option : this.optionList) {
            this.console.p("  -").p(option.external);
            switch (option.kind) {
                case BOOLEAN: {
                    break;
                }
                case WORD: {
                    this.console.p(" <word>");
                    break;
                }
                case INTEGER: {
                    this.console.p(" <num>");
                    break;
                }
                case FILE: {
                    this.console.p(" <file>");
                    break;
                }
                case DIRECTORY: {
                    this.console.p(" <dir>");
                    break;
                }
                case ATTRIBUTE: {
                    this.console.p(" <att>");
                    break;
                }
                default: {
                    assert (false) : "Invalid option " + option;
                    break;
                }
            }
            this.console.align(n).wrap(n, option.description).pln();
        }
        this.console.flush();
    }

    public int process(String[] stringArray) {
        int n;
        this.options.clear();
        for (n = 0; n < stringArray.length && stringArray[n].startsWith("-"); ++n) {
            Object object;
            if (1 >= stringArray[n].length()) {
                this.error("empty command line option");
                continue;
            }
            String string = stringArray[n].substring(1);
            Option option = this.externalMap.get(string);
            if (null == option) {
                this.error("unrecognized command line option " + string);
                continue;
            }
            if (!option.multiple && this.options.containsKey(option.internal)) {
                this.error("repeated " + string + " option");
                continue;
            }
            if (Option.Kind.BOOLEAN == option.kind) {
                this.options.put(option.internal, Boolean.TRUE);
                continue;
            }
            if (stringArray.length == n + 1) {
                this.error(string + " option without argument");
                continue;
            }
            Object object2 = null;
            ++n;
            switch (option.kind) {
                case WORD: {
                    object2 = stringArray[n];
                    break;
                }
                case INTEGER: {
                    try {
                        object2 = new Integer(stringArray[n]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.error("malformed integer argument to " + string + " option");
                    }
                    break;
                }
                case FILE: {
                    object = new File(stringArray[n]);
                    if (((File)object).exists()) {
                        object2 = object;
                        break;
                    }
                    this.error("nonexistent file argument to " + string + " option");
                    break;
                }
                case DIRECTORY: {
                    File file = new File(stringArray[n]);
                    if (file.exists()) {
                        if (file.isDirectory()) {
                            object2 = file;
                            break;
                        }
                        this.error(stringArray[n] + " not a directory");
                        break;
                    }
                    this.error("nonexistent directory argument to " + string + " option");
                    break;
                }
                case ATTRIBUTE: {
                    PParser pParser = new PParser(new StringReader(stringArray[n]), "<console>", stringArray[n].length());
                    Result result2 = null;
                    try {
                        result2 = pParser.pAttribute(0);
                    }
                    catch (IOException iOException) {
                        this.error("internal error: " + iOException);
                    }
                    if (!result2.hasValue()) {
                        this.error("malformed attribute " + stringArray[n] + ": " + ((ParseError)result2).msg);
                        break;
                    }
                    if (result2.index != stringArray[n].length()) {
                        this.error("extra characters after " + stringArray[n].substring(0, result2.index));
                        break;
                    }
                    object2 = ((SemanticValue)result2).value;
                    break;
                }
                default: {
                    assert (false) : "Unrecognized option " + option;
                    break;
                }
            }
            if (null == object2) continue;
            if (option.multiple) {
                if (this.options.containsKey(option.internal)) {
                    object = (List)this.options.get(option.internal);
                    object.add(object2);
                    continue;
                }
                object = new ArrayList();
                object.add(object2);
                this.options.put(option.internal, object);
                continue;
            }
            this.options.put(option.internal, object2);
        }
        return n;
    }

    public void initDefaultValues() {
        for (Option option : this.optionList) {
            if (this.options.containsKey(option.internal)) continue;
            ArrayList arrayList = null;
            if (null != option.value) {
                if (option.multiple) {
                    ArrayList<Object> arrayList2 = new ArrayList<Object>(1);
                    arrayList2.add(option.value);
                    arrayList = arrayList2;
                } else {
                    arrayList = option.value;
                }
            } else if (option.multiple) {
                arrayList = new ArrayList(0);
            }
            this.options.put(option.internal, arrayList);
        }
    }

    public void initFlags(boolean bl) {
        for (Option option : this.optionList) {
            if (Option.Kind.BOOLEAN != option.kind || this.options.containsKey(option.internal)) continue;
            this.options.put(option.internal, bl);
        }
    }

    public void initFlags(String string, boolean bl) {
        for (Option option : this.optionList) {
            if (Option.Kind.BOOLEAN != option.kind || !option.internal.startsWith(string) || this.options.containsKey(option.internal)) continue;
            this.options.put(option.internal, bl);
        }
    }

    public boolean hasValue(String string) {
        return this.options.containsKey(string);
    }

    public boolean hasPrefixValue(String string) {
        for (String string2 : this.options.keySet()) {
            if (!string2.startsWith(string)) continue;
            return true;
        }
        return false;
    }

    public Object getValue(String string) {
        if (this.options.containsKey(string)) {
            return this.options.get(string);
        }
        throw new IllegalArgumentException("Undefined internal option " + string);
    }

    public boolean test(String string) {
        if (this.options.containsKey(string)) {
            return (Boolean)this.options.get(string);
        }
        throw new IllegalArgumentException("Undefined boolean option " + string);
    }

    public int getInt(String string) {
        if (this.options.containsKey(string)) {
            return (Integer)this.options.get(string);
        }
        throw new IllegalArgumentException("Undefined integer option " + string);
    }

    public String getString(String string) {
        if (this.options.containsKey(string)) {
            return (String)this.options.get(string);
        }
        throw new IllegalArgumentException("Undefined word option " + string);
    }

    public File getFile(String string) {
        if (this.options.containsKey(string)) {
            return (File)this.options.get(string);
        }
        throw new IllegalArgumentException("Undefined file/directory option " + string);
    }

    public List<?> getList(String string) {
        if (this.options.containsKey(string)) {
            return (List)this.options.get(string);
        }
        throw new IllegalArgumentException("Undefined option " + string + " with multiple values");
    }

    public List<Attribute> getAttributeList(String string) {
        List<Attribute> list = this.getList(string);
        if (0 < list.size()) {
            Attribute attribute = list.get(0);
        }
        return list;
    }

    public List<File> getFileList(String string) {
        List<File> list = this.getList(string);
        if (0 < list.size()) {
            File file = list.get(0);
        }
        return list;
    }

    protected void check(Option option, Object object) {
        switch (option.kind) {
            case BOOLEAN: {
                if (object instanceof Boolean) break;
                throw new IllegalArgumentException("Invalid value " + object + " for boolean option " + option.internal);
            }
            case WORD: {
                if (object instanceof String) break;
                throw new IllegalArgumentException("Invalid value " + object + " for word option " + option.internal);
            }
            case INTEGER: {
                if (object instanceof Integer) break;
                throw new IllegalArgumentException("Invalid value " + object + " for number option " + option.internal);
            }
            case FILE: {
                if (object instanceof File && ((File)object).exists()) break;
                throw new IllegalArgumentException("Invalid value " + object + " for file option " + option.internal);
            }
            case DIRECTORY: {
                if (object instanceof File && ((File)object).isDirectory()) break;
                throw new IllegalArgumentException("Invalid value " + object + " for directory option " + option.internal);
            }
            case ATTRIBUTE: {
                if (object instanceof Attribute) break;
                throw new IllegalArgumentException("Invalid value " + object + " for attribute option " + option.internal);
            }
            default: {
                assert (false) : "Invalid option " + option;
                break;
            }
        }
    }

    public void setValue(String string, Object arrayList) {
        Option option = this.internalMap.get(string);
        if (null == option) {
            throw new IllegalArgumentException("Undefined option " + string);
        }
        this.check(option, arrayList);
        if (option.multiple) {
            ArrayList arrayList2 = new ArrayList(1);
            arrayList2.add(arrayList);
            arrayList = arrayList2;
        }
        this.options.put(string, arrayList);
    }

    public void setValue(String string, boolean bl) {
        Option option = this.internalMap.get(string);
        if (null == option) {
            throw new IllegalArgumentException("Undefined option " + string);
        }
        if (Option.Kind.BOOLEAN != option.kind) {
            throw new IllegalArgumentException("Not a boolean-valued option " + string);
        }
        this.options.put(string, bl);
    }

    public File locate(String string) throws FileNotFoundException {
        List<File> list = this.getFileList(INPUT_DIRECTORY);
        if (null != list) {
            for (File file : list) {
                File file2 = new File(file, string);
                if (!file2.exists() || !file2.isFile()) continue;
                return file2;
            }
        }
        throw new FileNotFoundException(string + " not found");
    }

    public Reader getReader(File file) throws IOException {
        return this.getReader(new FileInputStream(file));
    }

    public Reader getReader(InputStream inputStream) throws UnsupportedEncodingException {
        String string = (String)this.options.get(INPUT_ENCODING);
        if (null == string) {
            return new BufferedReader(new InputStreamReader(inputStream));
        }
        return new BufferedReader(new InputStreamReader(inputStream, string));
    }

    public File getOutputDirectory() {
        return this.getFile(OUTPUT_DIRECTORY);
    }

    public Writer getWriter(File file) throws IOException {
        return this.getWriter(new FileOutputStream(file));
    }

    public Writer getWriter(OutputStream outputStream) throws UnsupportedEncodingException {
        String string = (String)this.options.get(OUTPUT_ENCODING);
        if (null == string) {
            return new BufferedWriter(new OutputStreamWriter(outputStream));
        }
        return new BufferedWriter(new OutputStreamWriter(outputStream, string));
    }

    public boolean seenError() {
        return 0 < this.errors;
    }

    public int errorCount() {
        return this.errors;
    }

    public void error() {
        ++this.errors;
    }

    public void error(String string) {
        this.errConsole.p("error: ").pln(string).flush();
        ++this.errors;
    }

    public void error(String string, Node node) {
        this.errConsole.loc(node).p(": ");
        this.error(string);
    }

    public void warning() {
        ++this.warnings;
    }

    public void warning(String string) {
        this.errConsole.p("warning: ").pln(string).flush();
        ++this.warnings;
    }

    public void warning(String string, Node node) {
        this.errConsole.loc(node).p(": ");
        this.warning(string);
    }

    public void exit() {
        if (0 < this.errors) {
            if (1 == this.errors) {
                this.errConsole.p("1 error");
            } else {
                this.errConsole.p(this.errors);
                this.errConsole.p(" errors");
            }
        }
        if (0 < this.warnings) {
            if (0 < this.errors) {
                this.errConsole.p(", ");
            }
            if (1 == this.warnings) {
                this.errConsole.p("1 warning");
            } else {
                this.errConsole.p(this.warnings);
                this.errConsole.p(" warnings");
            }
        }
        if (0 < this.errors || 0 < this.warnings) {
            this.errConsole.pln().flush();
        }
        if (0 < this.errors) {
            System.exit(1);
        } else {
            System.exit(0);
        }
    }
}

