/*
 * Decompiled with CFR 0.152.
 */
package xtc.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pair<T>
implements Iterable<T> {
    public static final Pair EMPTY = new Pair();
    T head;
    Pair<T> tail;

    private Pair() {
        this.head = null;
        this.tail = null;
    }

    public Pair(T t) {
        this.head = t;
        this.tail = Pair.empty();
    }

    public Pair(T t, Pair<T> pair) {
        if (null == pair) {
            throw new NullPointerException("Null tail");
        }
        this.head = t;
        this.tail = pair;
    }

    public int hashCode() {
        Pair<T> pair = this;
        int n = 1;
        while (EMPTY != pair) {
            T t = pair.head;
            n = 31 * n + (null == t ? 0 : t.hashCode());
            pair = pair.tail;
        }
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Pair)) {
            return false;
        }
        Pair<T> pair = this;
        Pair<T> pair2 = (Pair<T>)object;
        while (EMPTY != pair && EMPTY != pair2) {
            T t = pair.head;
            T t2 = pair2.head;
            if (!(null != t ? t.equals(t2) : null == t2)) {
                return false;
            }
            pair = pair.tail;
            pair2 = pair2.tail;
        }
        return EMPTY == pair && EMPTY == pair2;
    }

    public boolean isEmpty() {
        return this == EMPTY;
    }

    public T head() {
        if (this == EMPTY) {
            throw new IllegalStateException("Empty list");
        }
        return this.head;
    }

    public T setHead(T t) {
        if (this == EMPTY) {
            throw new IllegalStateException("Empty list");
        }
        T t2 = this.head;
        this.head = t;
        return t2;
    }

    public Pair<T> tail() {
        if (this == EMPTY) {
            throw new IllegalStateException("Empty list");
        }
        return this.tail;
    }

    public Pair<T> setTail(Pair<T> pair) {
        if (null == pair) {
            throw new NullPointerException("Null tail");
        }
        if (this == EMPTY) {
            throw new IllegalStateException("Empty list");
        }
        Pair<T> pair2 = this.tail;
        this.tail = pair;
        return pair2;
    }

    public T get(int n) {
        if (0 > n) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size());
        }
        Pair<T> pair = this;
        int n2 = 0;
        while (EMPTY != pair) {
            if (n == n2) {
                return pair.head;
            }
            ++n2;
            pair = pair.tail;
        }
        throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + n2);
    }

    public T set(int n, T t) {
        if (0 > n) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size());
        }
        Pair<T> pair = this;
        int n2 = 0;
        while (EMPTY != pair) {
            if (n == n2) {
                T t2 = pair.head;
                pair.head = t;
                return t2;
            }
            ++n2;
            pair = pair.tail;
        }
        throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + n2);
    }

    public int size() {
        Pair<T> pair = this;
        int n = 0;
        while (pair != EMPTY) {
            ++n;
            pair = pair.tail;
        }
        return n;
    }

    public boolean contains(Object object) {
        Pair<T> pair = this;
        while (EMPTY != pair) {
            T t = pair.head;
            if (null == object ? null == t : object.equals(t)) {
                return true;
            }
            pair = pair.tail;
        }
        return false;
    }

    public boolean consists() {
        return EMPTY == this;
    }

    public boolean consists(Object object) {
        return EMPTY != this && (null == object ? null == this.head : object.equals(this.head)) && EMPTY == this.tail;
    }

    public boolean consists(Object object, Object object2) {
        Pair<T> pair = this;
        if (EMPTY == pair || !(null != object ? object.equals(pair.head) : null == pair.head)) {
            return false;
        }
        pair = pair.tail;
        if (EMPTY == pair || !(null != object2 ? object2.equals(pair.head) : null == pair.head)) {
            return false;
        }
        return EMPTY == pair.tail;
    }

    public boolean consists(Object object, Object object2, Object object3) {
        Pair<T> pair = this;
        if (EMPTY == pair || !(null != object ? object.equals(pair.head) : null == pair.head)) {
            return false;
        }
        pair = pair.tail;
        if (EMPTY == pair || !(null != object2 ? object2.equals(pair.head) : null == pair.head)) {
            return false;
        }
        pair = pair.tail;
        if (EMPTY == pair || !(null != object3 ? object3.equals(pair.head) : null == pair.head)) {
            return false;
        }
        return EMPTY == pair.tail;
    }

    public boolean consists(Object object, Object object2, Object object3, Object object4) {
        Pair<T> pair = this;
        if (EMPTY == pair || !(null != object ? object.equals(pair.head) : null == pair.head)) {
            return false;
        }
        pair = pair.tail;
        if (EMPTY == pair || !(null != object2 ? object2.equals(pair.head) : null == pair.head)) {
            return false;
        }
        pair = pair.tail;
        if (EMPTY == pair || !(null != object3 ? object3.equals(pair.head) : null == pair.head)) {
            return false;
        }
        pair = pair.tail;
        if (EMPTY == pair || !(null != object4 ? object4.equals(pair.head) : null == pair.head)) {
            return false;
        }
        return EMPTY == pair.tail;
    }

    public boolean consists(Object object, Object object2, Object object3, Object object4, Object object5) {
        Pair<T> pair = this;
        if (EMPTY == pair || !(null != object ? object.equals(pair.head) : null == pair.head)) {
            return false;
        }
        pair = pair.tail;
        if (EMPTY == pair || !(null != object2 ? object2.equals(pair.head) : null == pair.head)) {
            return false;
        }
        pair = pair.tail;
        if (EMPTY == pair || !(null != object3 ? object3.equals(pair.head) : null == pair.head)) {
            return false;
        }
        pair = pair.tail;
        if (EMPTY == pair || !(null != object4 ? object4.equals(pair.head) : null == pair.head)) {
            return false;
        }
        pair = pair.tail;
        if (EMPTY == pair || !(null != object5 ? object5.equals(pair.head) : null == pair.head)) {
            return false;
        }
        return EMPTY == pair.tail;
    }

    public boolean consists(Object ... objectArray) {
        int n;
        Pair<T> pair = this;
        for (n = 0; EMPTY != pair && n < objectArray.length; ++n) {
            T t = pair.head;
            Object object = objectArray[n];
            if (!(null != object ? object.equals(t) : null == t)) {
                return false;
            }
            pair = pair.tail;
        }
        return EMPTY == pair && objectArray.length == n;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private Pair<T> pair;
            {
                this.pair = Pair.this;
            }

            @Override
            public boolean hasNext() {
                return EMPTY != this.pair;
            }

            @Override
            public T next() {
                if (EMPTY == this.pair) {
                    throw new NoSuchElementException();
                }
                Object t = this.pair.head;
                this.pair = this.pair.tail;
                return t;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Pair<T> reverse() {
        Pair<T> pair = this;
        Pair<T> pair2 = Pair.empty();
        while (EMPTY != pair) {
            Pair<T> pair3 = pair2;
            pair2 = pair;
            pair = pair.tail;
            pair2.tail = pair3;
        }
        return pair2;
    }

    public Pair<T> add(T t) {
        if (this == EMPTY) {
            Pair<T> pair = new Pair<T>(t);
            return pair;
        }
        Pair<T> pair = this;
        while (EMPTY != pair.tail) {
            pair = pair.tail;
        }
        pair.tail = new Pair<T>(t);
        return pair.tail;
    }

    public void setLastTail(Pair<T> pair) {
        if (null == pair) {
            throw new NullPointerException("Null tail");
        }
        if (EMPTY == this) {
            throw new IllegalStateException("Empty list");
        }
        Pair<T> pair2 = this;
        while (EMPTY != pair2.tail) {
            pair2 = pair2.tail;
        }
        pair2.tail = pair;
    }

    public Pair<T> append(Pair<T> pair) {
        Pair<T> pair2;
        if (null == pair) {
            throw new NullPointerException("Null tail");
        }
        if (EMPTY == this) {
            return pair;
        }
        Pair<T> pair3 = this;
        Pair<T> pair4 = pair2 = new Pair<T>(pair3.head);
        while (EMPTY != pair3.tail) {
            pair3 = pair3.tail;
            pair4.tail = new Pair<T>(pair3.head);
            pair4 = pair4.tail;
        }
        pair4.tail = pair;
        return pair2;
    }

    public Pair<T> combine(Pair<T> pair) {
        Pair<T> pair2 = this;
        Pair<T> pair3 = pair;
        while (EMPTY != pair2) {
            T t = pair2.head;
            if (!pair.contains(t)) {
                pair3 = new Pair<T>(t, pair3);
            }
            pair2 = pair2.tail;
        }
        return pair3;
    }

    public Pair<T> intersect(Pair<T> pair) {
        Pair<T> pair2 = this;
        Pair<T> pair3 = Pair.empty();
        while (EMPTY != pair2) {
            T t = pair2.head;
            if (pair.contains(t)) {
                pair3 = new Pair<T>(t, pair3);
            }
            pair2 = pair2.tail;
        }
        return pair3;
    }

    public Pair<T> subtract(Pair<T> pair) {
        Pair<T> pair2 = this;
        Pair<T> pair3 = Pair.empty();
        while (EMPTY != pair2) {
            T t = pair2.head;
            if (!pair.contains(t)) {
                pair3 = new Pair<T>(t, pair3);
            }
            pair2 = pair2.tail;
        }
        return pair3;
    }

    public void addTo(List<? super T> list) {
        Pair<T> pair = this;
        while (EMPTY != pair) {
            list.add(pair.head);
            pair = pair.tail;
        }
    }

    public List<T> list() {
        ArrayList arrayList = new ArrayList(this.size());
        this.addTo(arrayList);
        return arrayList;
    }

    public String toString() {
        Pair<T> pair = this;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        while (EMPTY != pair) {
            T t = pair.head;
            stringBuilder.append(null == t ? "null" : t.toString());
            pair = pair.tail;
            if (EMPTY == pair) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public static final <T> Pair<T> empty() {
        return EMPTY;
    }
}

